/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.Arrays;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.robotics.kinematics.fourbar.FourBar;
import us.ihmc.robotics.kinematics.fourbar.FourBarAngle;
import us.ihmc.robotics.kinematics.fourbar.FourBarVertex;
import us.ihmc.robotics.screwTheory.FourBarKinematicLoopFunctionTools;
import us.ihmc.robotics.screwTheory.KinematicLoopFunction;

public class FourBarKinematicLoopFunction
implements KinematicLoopFunction {
    private static final double EPSILON = 1.0E-7;
    private static final boolean DEBUG = false;
    private final String name;
    private final FourBarVertex masterVertex;
    private final FourBar fourBar = new FourBar();
    private final RevoluteJointBasics jointA;
    private final RevoluteJointBasics jointB;
    private final RevoluteJointBasics jointC;
    private final RevoluteJointBasics jointD;
    private final List<RevoluteJointBasics> joints;
    private final FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterA = new FourBarKinematicLoopFunctionTools.FourBarToJointConverter();
    private final FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterB = new FourBarKinematicLoopFunctionTools.FourBarToJointConverter();
    private final FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterC = new FourBarKinematicLoopFunctionTools.FourBarToJointConverter();
    private final FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterD = new FourBarKinematicLoopFunctionTools.FourBarToJointConverter();
    private final FourBarKinematicLoopFunctionTools.FourBarToJointConverter[] converters = new FourBarKinematicLoopFunctionTools.FourBarToJointConverter[]{this.converterA, this.converterB, this.converterC, this.converterD};
    private final DMatrixRMaj loopJacobianMatrix = new DMatrixRMaj(4, 1);
    private final DMatrixRMaj loopConvectiveTermMatrix = new DMatrixRMaj(4, 1);
    private final int masterJointIndex;
    private final int[] actuatedJointIndices;

    public FourBarKinematicLoopFunction(String name, List<? extends RevoluteJointBasics> joints, int masterJointIndex) {
        this(name, joints.toArray(new RevoluteJointBasics[0]), masterJointIndex);
    }

    public FourBarKinematicLoopFunction(String name, RevoluteJointBasics[] joints, int masterJointIndex) {
        this.name = name;
        joints = Arrays.copyOf(joints, joints.length);
        this.masterJointIndex = FourBarKinematicLoopFunctionTools.configureFourBarKinematics(joints, this.converters, this.fourBar, masterJointIndex, 1.0E-7);
        this.actuatedJointIndices = new int[]{this.masterJointIndex};
        this.joints = Arrays.asList(joints);
        this.jointA = joints[0];
        this.jointB = joints[1];
        this.jointC = joints[2];
        this.jointD = joints[3];
        this.masterVertex = this.fourBar.getVertex(FourBarAngle.values[this.masterJointIndex]);
    }

    public boolean isInverted() {
        return this.fourBar.isInverted();
    }

    public Bound updateState(boolean updateVelocity, boolean updateAcceleration) {
        Bound limit;
        if (updateAcceleration && !updateVelocity) {
            throw new IllegalArgumentException("updateVelocity needs to be true for updateAcceleration to be true.");
        }
        this.clampMasterJointPosition();
        RevoluteJointBasics masterJoint = this.getMasterJoint();
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter masterConverter = this.converters[this.masterJointIndex];
        double angle = masterConverter.toFourBarInteriorAngle(masterJoint.getQ());
        if (updateVelocity) {
            double angleDot = masterConverter.toFourBarInteriorAngularDerivative(masterJoint.getQd());
            if (updateAcceleration) {
                double angleDDot = masterConverter.toFourBarInteriorAngularDerivative(masterJoint.getQdd());
                limit = this.fourBar.update(FourBarAngle.values[this.masterJointIndex], angle, angleDot, angleDDot);
            } else {
                limit = this.fourBar.update(FourBarAngle.values[this.masterJointIndex], angle, angleDot);
            }
        } else {
            limit = this.fourBar.update(FourBarAngle.values[this.masterJointIndex], angle);
        }
        for (int i = 0; i < 4; ++i) {
            if (i == this.masterJointIndex) continue;
            RevoluteJointBasics joint = this.joints.get(i);
            FourBarKinematicLoopFunctionTools.FourBarToJointConverter converter = this.converters[i];
            FourBarVertex fourBarVertex = this.fourBar.getVertex(FourBarAngle.values[i]);
            joint.setQ(converter.toJointAngle(fourBarVertex.getAngle()));
            if (updateVelocity) {
                joint.setQd(converter.toJointDerivative(fourBarVertex.getAngleDot()));
            }
            if (!updateAcceleration) continue;
            joint.setQdd(converter.toJointDerivative(fourBarVertex.getAngleDDot()));
        }
        this.updateLoopJacobian();
        this.updateLoopConvectiveTerm();
        return limit;
    }

    public void updateEffort() {
        double tau = 0.0;
        for (int i = 0; i < 4; ++i) {
            RevoluteJointBasics joint = this.joints.get(i);
            tau += this.loopJacobianMatrix.get(i, 0) * joint.getTau();
            joint.setTau(0.0);
        }
        this.getMasterJoint().setTau(tau / this.loopJacobianMatrix.get(this.masterJointIndex, 0));
    }

    @Override
    public void adjustConfiguration(DMatrixRMaj jointConfigurations) {
        if (jointConfigurations.getNumRows() != 4 || jointConfigurations.getNumCols() != 1) {
            throw new IllegalArgumentException("Unexpected matrix size. [row=" + jointConfigurations.getNumRows() + ", col=" + jointConfigurations.getNumCols() + "].");
        }
        double angle = MathTools.clamp((double)jointConfigurations.get(this.masterJointIndex), (double)this.getMasterJoint().getJointLimitLower(), (double)this.getMasterJoint().getJointLimitUpper());
        this.fourBar.update(FourBarAngle.values[this.masterJointIndex], this.converters[this.masterJointIndex].toFourBarInteriorAngle(angle));
        for (int i = 0; i < 4; ++i) {
            double q = this.converters[i].toJointAngle(this.fourBar.getVertex(FourBarAngle.values[i]).getAngle());
            jointConfigurations.set(i, q);
        }
    }

    @Override
    public void adjustTau(DMatrixRMaj tauJoints) {
        if (tauJoints.getNumRows() != 4 || tauJoints.getNumCols() != 1) {
            throw new IllegalArgumentException("Unexpected matrix size. [row=" + tauJoints.getNumRows() + ", col=" + tauJoints.getNumCols() + "].");
        }
        double tau = 0.0;
        for (int i = 0; i < 4; ++i) {
            tau += this.loopJacobianMatrix.get(i, 0) * tauJoints.get(i);
            tauJoints.set(i, 0.0);
        }
        tauJoints.set(this.masterJointIndex, tau / this.loopJacobianMatrix.get(this.masterJointIndex, 0));
    }

    private void updateLoopJacobian() {
        double angle = this.converters[this.masterJointIndex].toFourBarInteriorAngle(this.getMasterJoint().getQ());
        double angleDot = this.converters[this.masterJointIndex].toFourBarInteriorAngularDerivative(1.0);
        this.fourBar.update(FourBarAngle.values[this.masterJointIndex], angle, angleDot);
        for (int i = 0; i < 4; ++i) {
            if (i == this.masterJointIndex) {
                this.loopJacobianMatrix.set(i, 0, 1.0);
                continue;
            }
            FourBarVertex fourBarVertex = this.fourBar.getVertex(FourBarAngle.values[i]);
            this.loopJacobianMatrix.set(i, 0, this.converters[i].toJointDerivative(fourBarVertex.getAngleDot()));
        }
    }

    private void updateLoopConvectiveTerm() {
        double angle = this.converters[this.masterJointIndex].toFourBarInteriorAngle(this.getMasterJoint().getQ());
        double angleDot = this.converters[this.masterJointIndex].toFourBarInteriorAngularDerivative(this.getMasterJoint().getQd());
        double angleDDot = 0.0;
        this.fourBar.update(FourBarAngle.values[this.masterJointIndex], angle, angleDot, angleDDot);
        for (int i = 0; i < 4; ++i) {
            if (i == this.masterJointIndex) {
                this.loopConvectiveTermMatrix.set(i, 0, 0.0);
                continue;
            }
            FourBarVertex fourBarVertex = this.fourBar.getVertex(FourBarAngle.values[i]);
            this.loopConvectiveTermMatrix.set(i, 0, this.converters[i].toJointDerivative(fourBarVertex.getAngleDDot()));
        }
    }

    public List<RevoluteJointBasics> getLoopJoints() {
        return this.joints;
    }

    private void clampMasterJointPosition() {
        RevoluteJointBasics masterJoint = this.getMasterJoint();
        if (masterJoint.getQ() < masterJoint.getJointLimitLower()) {
            masterJoint.setQ(masterJoint.getJointLimitLower());
        } else if (masterJoint.getQ() > masterJoint.getJointLimitUpper()) {
            masterJoint.setQ(masterJoint.getJointLimitUpper());
        }
    }

    public String getName() {
        return this.name;
    }

    public RevoluteJointBasics getJointA() {
        return this.jointA;
    }

    public RevoluteJointBasics getJointB() {
        return this.jointB;
    }

    public RevoluteJointBasics getJointC() {
        return this.jointC;
    }

    public RevoluteJointBasics getJointD() {
        return this.jointD;
    }

    public int getMasterJointIndex() {
        return this.masterJointIndex;
    }

    public FourBarVertex getMasterVertex() {
        return this.masterVertex;
    }

    @Override
    public int[] getActuatedJointIndices() {
        return this.actuatedJointIndices;
    }

    public RevoluteJointBasics getMasterJoint() {
        return this.joints.get(this.masterJointIndex);
    }

    @Override
    public DMatrixRMaj getLoopJacobian() {
        return this.loopJacobianMatrix;
    }

    @Override
    public DMatrixRMaj getLoopConvectiveTerm() {
        return this.loopConvectiveTermMatrix;
    }

    public FourBar getFourBar() {
        return this.fourBar;
    }

    public FourBarKinematicLoopFunctionTools.FourBarToJointConverter[] getConverters() {
        return this.converters;
    }
}

