/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotSide;

import java.util.EnumSet;
import java.util.Random;
import us.ihmc.robotics.robotSide.RobotSegment;

public enum RobotSide implements RobotSegment<RobotSide>
{
    LEFT,
    RIGHT;

    public static final EnumSet<RobotSide> set;
    public static final RobotSide[] values;

    public static RobotSide generateRandomRobotSide(Random random) {
        if (random.nextBoolean()) {
            return LEFT;
        }
        return RIGHT;
    }

    public RobotSide getOppositeSide() {
        if (this == RIGHT) {
            return LEFT;
        }
        return RIGHT;
    }

    public String getShortLowerCaseName() {
        return this.getCamelCaseNameForMiddleOfExpression().substring(0, 1).toLowerCase();
    }

    @Override
    public String getCamelCaseNameForStartOfExpression() {
        if (this == RIGHT) {
            return "right";
        }
        return "left";
    }

    public String getCamelCaseNameForMiddleOfExpression() {
        if (this == RIGHT) {
            return "Right";
        }
        return "Left";
    }

    public String getCamelCaseName() {
        return this.getCamelCaseNameForStartOfExpression();
    }

    public String getPascalCaseName() {
        return this.getCamelCaseNameForMiddleOfExpression();
    }

    public String getLowerCaseName() {
        if (this == RIGHT) {
            return "right";
        }
        return "left";
    }

    public String getSideNameInAllCaps() {
        if (this == RIGHT) {
            return "RIGHT";
        }
        return "LEFT";
    }

    public String getSideNameFirstLetter() {
        if (this == RIGHT) {
            return "R";
        }
        return "L";
    }

    public String getSideNameFirstLowerCaseLetter() {
        if (this == RIGHT) {
            return "r";
        }
        return "l";
    }

    public String getSideStringInRobonetFormat() {
        if (this == RIGHT) {
            return "/right_leg";
        }
        return "/left_leg";
    }

    public String getSideStringInRobonetFormatWithoutSlash() {
        if (this == RIGHT) {
            return "right_leg";
        }
        return "left_leg";
    }

    public double negateIfLeftSide(double value) {
        if (this == LEFT) {
            return -value;
        }
        return value;
    }

    public double negateIfRightSide(double value) {
        if (this == RIGHT) {
            return -value;
        }
        return value;
    }

    public float negateIfLeftSide(float value) {
        if (this == LEFT) {
            return -value;
        }
        return value;
    }

    public float negateIfRightSide(float value) {
        if (this == RIGHT) {
            return -value;
        }
        return value;
    }

    public void checkRobotSideMatch(RobotSide other) {
        if (this != other) {
            throw new RobotSideMismatchException();
        }
    }

    public static RobotSide getSideFromString(String robotSideName) {
        RobotSide[] sides;
        for (RobotSide side : sides = values) {
            if (robotSideName.equals(side.getSideNameFirstLetter())) {
                return side;
            }
            if (robotSideName.equals(side.getSideNameFirstLetter().toLowerCase())) {
                return side;
            }
            if (robotSideName.equals(side.getCamelCaseNameForStartOfExpression())) {
                return side;
            }
            if (!robotSideName.equals(side.getCamelCaseNameForMiddleOfExpression())) continue;
            return side;
        }
        return null;
    }

    public static void main(String[] args) {
        String testString = LEFT.toString();
        RobotSide side = RobotSide.getSideFromString(testString);
        System.out.println(side.toString());
        testString = RIGHT.toString();
        side = RobotSide.getSideFromString(testString);
        System.out.println(side.toString());
        testString = "junk";
        side = RobotSide.getSideFromString(testString);
        System.out.println(side.toString());
    }

    public static String getDocumentation(RobotSide var) {
        switch (var) {
            case RIGHT: {
                return "refers to the RIGHT side of a robot";
            }
            case LEFT: {
                return "refers to the LEFT side of a robot";
            }
        }
        return "no documentation available";
    }

    public byte toByte() {
        return (byte)this.ordinal();
    }

    public static RobotSide fromByte(byte enumAsByte) {
        if (enumAsByte == -1) {
            return null;
        }
        return values[enumAsByte];
    }

    public RobotSide[] getValues() {
        return values;
    }

    @Override
    public EnumSet<RobotSide> getEnumSet() {
        return set;
    }

    @Override
    public Class<RobotSide> getClassType() {
        return RobotSide.class;
    }

    static {
        set = EnumSet.allOf(RobotSide.class);
        values = RobotSide.values();
    }

    private static class RobotSideMismatchException
    extends RuntimeException {
        private static final long serialVersionUID = -159864473420885631L;
    }
}

