/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotController;

import java.util.ArrayList;
import us.ihmc.robotics.robotController.OutputProcessor;
import us.ihmc.robotics.robotController.RawOutputWriter;
import us.ihmc.robotics.robotController.RawSensorReader;
import us.ihmc.robotics.robotController.SensorProcessor;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.registry.YoRegistry;

public abstract class AbstractModularRobotController
implements RobotController {
    protected final YoRegistry registry;
    protected RawSensorReader rawSensorReader;
    protected SensorProcessor sensorProcessor;
    protected ArrayList<RobotController> robotControllers = new ArrayList();
    protected OutputProcessor outputProcessor;
    protected RawOutputWriter rawOutputWriter;

    public AbstractModularRobotController(String name) {
        this.registry = new YoRegistry(name);
    }

    public abstract void doControl();

    public void initialize() {
        if (this.rawSensorReader != null) {
            this.rawSensorReader.initialize();
        }
        if (this.sensorProcessor != null) {
            this.sensorProcessor.initialize();
        }
        for (int i = 0; i < this.robotControllers.size(); ++i) {
            this.robotControllers.get(i).initialize();
        }
        if (this.outputProcessor != null) {
            this.outputProcessor.initialize();
        }
        if (this.rawOutputWriter != null) {
            this.rawOutputWriter.initialize();
        }
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public String getName() {
        return this.registry.getName();
    }

    public void setRawSensorReader(RawSensorReader rawSensorReader) {
        if (this.rawSensorReader != null) {
            throw new RuntimeException("Already have a rawSensorReader");
        }
        this.rawSensorReader = rawSensorReader;
        this.registry.addChild(rawSensorReader.getYoRegistry());
    }

    public void setSensorProcessor(SensorProcessor sensorProcessor) {
        if (this.sensorProcessor != null) {
            throw new RuntimeException("Already have a sensorProcessor");
        }
        this.sensorProcessor = sensorProcessor;
        this.registry.addChild(sensorProcessor.getYoRegistry());
    }

    public void addRobotController(RobotController robotController) {
        if (robotController == this) {
            throw new RuntimeException("Cannot add self to modular robot controller");
        }
        this.robotControllers.add(robotController);
        YoRegistry controllerRegistry = robotController.getYoRegistry();
        if (controllerRegistry != null) {
            this.registry.addChild(controllerRegistry);
        }
    }

    public void setOutputProcessor(OutputProcessor outputProcessor) {
        if (this.outputProcessor != null) {
            throw new RuntimeException("Already have a outputProcessor");
        }
        this.outputProcessor = outputProcessor;
        if (this.outputProcessor != null) {
            this.registry.addChild(outputProcessor.getYoRegistry());
        }
    }

    public void setRawOutputWriter(RawOutputWriter rawOutputWriter) {
        if (this.rawOutputWriter != null) {
            throw new RuntimeException("Already have a rawOutputWriter");
        }
        this.rawOutputWriter = rawOutputWriter;
        this.registry.addChild(rawOutputWriter.getYoRegistry());
    }

    public RawSensorReader getRawSensorReader() {
        return this.rawSensorReader;
    }

    public SensorProcessor getSensorProcessor() {
        return this.sensorProcessor;
    }

    public ArrayList<RobotController> getRobotControllers() {
        return this.robotControllers;
    }

    public OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    public RawOutputWriter getRawOutputWriter() {
        return this.rawOutputWriter;
    }

    public String getDescription() {
        return "ModularRobotController with a rawSensorReader, sensorProcessor, robotController, outputProcessor, and rawOutputWriter";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Modular Robot Controller:\n");
        if (this.rawSensorReader != null) {
            buf.append("Raw sensor reader:\n" + this.rawSensorReader.toString() + "\n");
        }
        if (this.sensorProcessor != null) {
            buf.append("Sensor processor:\n" + this.sensorProcessor.toString() + "\n");
        }
        buf.append("Robot controllers:\n");
        for (RobotController robotController : this.robotControllers) {
            buf.append(robotController.getClass().getSimpleName() + "\n");
        }
        buf.append("\n");
        if (this.outputProcessor != null) {
            buf.append("Output processor:\n" + this.outputProcessor.toString() + "\n");
        }
        if (this.rawOutputWriter != null) {
            buf.append("Raw output writer:\n" + this.rawOutputWriter.toString());
        }
        return buf.toString();
    }
}

