/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class ZUpPreserveYReferenceFrame
extends ReferenceFrame {
    private final Vector3D translation = new Vector3D();
    private final ReferenceFrame worldFrame;
    private final FramePoint3D origin;
    private final RotationMatrix nonZUpToWorldRotation = new RotationMatrix();
    private final RotationMatrix zUpToWorldRotation = new RotationMatrix();
    private final Point3D originPoint3d = new Point3D();
    private final RigidBodyTransform nonZUpToWorld = new RigidBodyTransform();
    private final Vector3D xAxis = new Vector3D();
    private final Vector3D yAxis = new Vector3D();
    private final Vector3D zAxis = new Vector3D();

    public ZUpPreserveYReferenceFrame(ReferenceFrame worldFrame, ReferenceFrame nonZUpFrame, String name) {
        this(worldFrame, new FramePoint3D(nonZUpFrame), name);
    }

    public ZUpPreserveYReferenceFrame(ReferenceFrame worldFrame, FramePoint3D origin, String name) {
        super(name, worldFrame, false, true);
        this.worldFrame = worldFrame;
        this.origin = new FramePoint3D((FrameTuple3DReadOnly)origin);
        this.update();
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.origin.getReferenceFrame().getTransformToDesiredFrame(this.nonZUpToWorld, this.worldFrame);
        this.nonZUpToWorldRotation.set((RotationMatrixReadOnly)this.nonZUpToWorld.getRotation());
        double yAxisX = this.nonZUpToWorldRotation.getM01();
        double yAxisY = this.nonZUpToWorldRotation.getM11();
        this.yAxis.set(yAxisX, yAxisY, 0.0);
        this.yAxis.normalize();
        this.zAxis.set(0.0, 0.0, 1.0);
        this.xAxis.cross((Tuple3DReadOnly)this.yAxis, (Tuple3DReadOnly)this.zAxis);
        this.zUpToWorldRotation.setColumns((Tuple3DReadOnly)this.xAxis, (Tuple3DReadOnly)this.yAxis, (Tuple3DReadOnly)this.zAxis);
        transformToParent.getRotation().set((RotationMatrixReadOnly)this.zUpToWorldRotation);
        this.originPoint3d.set((Tuple3DReadOnly)this.origin);
        this.nonZUpToWorld.transform((Point3DBasics)this.originPoint3d);
        this.translation.set((Tuple3DReadOnly)this.originPoint3d);
        transformToParent.getTranslation().set((Tuple3DReadOnly)this.translation);
    }
}

