/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class ZUpFrame
extends ReferenceFrame {
    private final Vector3D euler = new Vector3D();
    private final Vector3D translation = new Vector3D();
    private final ReferenceFrame worldFrame;
    private final FramePoint3D origin;
    private final RotationMatrix nonZUpToWorldRotation = new RotationMatrix();
    private final Point3D originPoint3d = new Point3D();
    private final RigidBodyTransform nonZUpToWorld = new RigidBodyTransform();

    public ZUpFrame(ReferenceFrame worldFrame, ReferenceFrame nonZUpFrame, String name) {
        this(worldFrame, new FramePoint3D(nonZUpFrame), name);
    }

    public ZUpFrame(ReferenceFrame worldFrame, FramePoint3D origin, String name) {
        super(name, worldFrame, false, true);
        this.worldFrame = worldFrame;
        this.origin = new FramePoint3D((FrameTuple3DReadOnly)origin);
        this.update();
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.origin.getReferenceFrame().getTransformToDesiredFrame(this.nonZUpToWorld, this.worldFrame);
        this.nonZUpToWorldRotation.set((RotationMatrixReadOnly)this.nonZUpToWorld.getRotation());
        double yaw = this.nonZUpToWorldRotation.getYaw();
        this.euler.set(0.0, 0.0, yaw);
        transformToParent.setRotationEulerAndZeroTranslation((Vector3DReadOnly)this.euler);
        this.originPoint3d.set((Tuple3DReadOnly)this.origin);
        this.nonZUpToWorld.transform((Point3DBasics)this.originPoint3d);
        this.translation.set((Tuple3DReadOnly)this.originPoint3d);
        transformToParent.getTranslation().set((Tuple3DReadOnly)this.translation);
    }
}

