/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class PoseReferenceFrame
extends ReferenceFrame {
    private final FramePose3D originPose;

    public PoseReferenceFrame(String frameName, ReferenceFrame parentFrame) {
        super(frameName, parentFrame, parentFrame.isAStationaryFrame(), false);
        this.originPose = new FramePose3D(parentFrame);
    }

    public PoseReferenceFrame(String frameName, FramePose3DReadOnly pose) {
        this(frameName, pose.getReferenceFrame());
        this.setPoseAndUpdate(pose);
    }

    public boolean containsNaN() {
        return this.originPose.containsNaN();
    }

    public void setX(double x) {
        this.originPose.setX(x);
    }

    public void setY(double y) {
        this.originPose.setY(y);
    }

    public void setZ(double z) {
        this.originPose.setZ(z);
    }

    public void setPoseAndUpdate(FramePose3DReadOnly pose) {
        this.originPose.set(pose);
        this.update();
    }

    public void setPoseAndUpdate(PoseReferenceFrame poseReferenceFrame) {
        this.originPose.set(poseReferenceFrame.originPose);
        this.update();
    }

    public void setPoseAndUpdate(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation) {
        this.originPose.set((FrameTuple3DReadOnly)position, orientation);
        this.update();
    }

    public void setPoseAndUpdate(Point3DReadOnly position, Orientation3DReadOnly orientation) {
        this.originPose.set((Tuple3DReadOnly)position, orientation);
        this.update();
    }

    public void setPoseAndUpdate(Pose3DReadOnly pose) {
        this.originPose.set(pose);
        this.update();
    }

    public void setPoseAndUpdate(RigidBodyTransformReadOnly transformToParent) {
        this.originPose.set(transformToParent);
        this.update();
    }

    public void setPositionWithoutChecksAndUpdate(Point3DReadOnly position) {
        this.originPose.getPosition().set((Tuple3DReadOnly)position);
        this.update();
    }

    public void setPositionWithoutChecksAndUpdate(double x, double y, double z) {
        this.originPose.getPosition().set(x, y, z);
        this.update();
    }

    public void setPositionAndUpdate(FramePoint3DReadOnly framePoint) {
        framePoint.checkReferenceFrameMatch(this.getParent());
        this.originPose.getPosition().set((FrameTuple3DReadOnly)framePoint);
        this.update();
    }

    public void setOrientationAndUpdate(Orientation3DReadOnly orientation3D) {
        this.originPose.getOrientation().set(orientation3D);
        this.update();
    }

    public void setOrientationAndUpdate(double qx, double qy, double qz, double qs) {
        this.originPose.getOrientation().set(qx, qy, qz, qs);
        this.update();
    }

    public void setOrientationAndUpdate(FrameOrientation3DReadOnly frameOrientation) {
        frameOrientation.checkReferenceFrameMatch(this.getParent());
        this.originPose.getOrientation().set(frameOrientation);
        this.update();
    }

    public void setXYFromPosition2dAndUpdate(FramePoint2DReadOnly position2d) {
        position2d.checkReferenceFrameMatch(this.getParent());
        this.originPose.getPosition().set((FrameTuple2DReadOnly)position2d);
        this.update();
    }

    public void translateAndUpdate(double x, double y, double z) {
        this.originPose.prependTranslation(x, y, z);
        this.update();
    }

    public double getX() {
        return this.originPose.getX();
    }

    public double getY() {
        return this.originPose.getY();
    }

    public double getZ() {
        return this.originPose.getZ();
    }

    public double getYaw() {
        return this.originPose.getYaw();
    }

    public double getPitch() {
        return this.originPose.getPitch();
    }

    public double getRoll() {
        return this.originPose.getRoll();
    }

    public void getPose(Point3D pointToPack, Orientation3DBasics quaternionToPack) {
        this.originPose.get((Tuple3DBasics)pointToPack, quaternionToPack);
    }

    public void getPose(RigidBodyTransform transformToPack) {
        this.getTransformToParent(transformToPack);
    }

    public void getPoseIncludingFrame(FramePoint3D framePointToPack, FrameOrientation3DBasics frameOrientationToPack) {
        this.originPose.get((FrameTuple3DBasics)framePointToPack, frameOrientationToPack);
    }

    public void getPoseIncludingFrame(FramePose3D framePoseToPack) {
        framePoseToPack.setIncludingFrame((FramePose3DReadOnly)this.originPose);
    }

    public Point3DReadOnly getPosition() {
        return this.originPose.getPosition();
    }

    public void getPosition(Point3D pointToPack) {
        pointToPack.set((Tuple3DReadOnly)this.originPose.getPosition());
    }

    public void getPositionIncludingFrame(FramePoint3D framePointToPack) {
        framePointToPack.setIncludingFrame((FrameTuple3DReadOnly)this.originPose.getPosition());
    }

    public QuaternionReadOnly getOrientation() {
        return this.originPose.getOrientation();
    }

    public void getOrientation(Orientation3DBasics quaternionToPack) {
        quaternionToPack.set((Orientation3DReadOnly)this.originPose.getOrientation());
    }

    public void getOrientation(RotationMatrix matrixToPack) {
        matrixToPack.set((Orientation3DReadOnly)this.originPose.getOrientation());
    }

    public void getOrientationIncludingFrame(FrameQuaternion frameOrientationToPack) {
        frameOrientationToPack.setIncludingFrame((FrameQuaternionReadOnly)this.originPose.getOrientation());
    }

    public void getPose2dIncludingFrame(FramePose2D framePose2dToPack) {
        framePose2dToPack.setIncludingFrame((FramePose3DReadOnly)this.originPose);
    }

    public void getPosition2dIncludingFrame(FramePoint2D framePoint2dToPack) {
        framePoint2dToPack.setIncludingFrame((FrameTuple3DReadOnly)this.originPose.getPosition());
    }

    public void interpolate(FramePose3D framePose1, FramePose3D framePose2, double alpha) {
        this.originPose.interpolate((FramePose3DReadOnly)framePose1, (FramePose3DReadOnly)framePose2, alpha);
    }

    public void interpolate(PoseReferenceFrame poseReferenceFrame1, PoseReferenceFrame poseReferenceFrame2, double alpha) {
        this.originPose.interpolate((FramePose3DReadOnly)poseReferenceFrame1.originPose, (FramePose3DReadOnly)poseReferenceFrame2.originPose, alpha);
    }

    public boolean epsilonEquals(PoseReferenceFrame otherPoseReferenceFrame, double epsilon) {
        return this.originPose.epsilonEquals(otherPoseReferenceFrame.originPose, epsilon);
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.originPose.checkReferenceFrameMatch(this.getParent());
        this.originPose.get((RigidBodyTransformBasics)transformToParent);
    }

    public String toString() {
        return super.toString() + ", originPose = " + this.originPose;
    }
}

