/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class OriginAndPointFrame
extends ReferenceFrame {
    private final FramePoint3D origin;
    private final FramePoint3D positionToPointAt;
    private final Vector3D xAxis = new Vector3D();
    private final Vector3D yAxis = new Vector3D();
    private final Vector3D zAxis = new Vector3D();
    private final RotationMatrix rotationMatrix = new RotationMatrix();
    private final Vector3D originVector = new Vector3D();

    public OriginAndPointFrame(String name, ReferenceFrame parentFrame) {
        super(name, parentFrame);
        this.origin = new FramePoint3D(parentFrame);
        this.positionToPointAt = new FramePoint3D(parentFrame);
    }

    public void setOriginAndPositionToPointAt(FramePoint3D origin, FramePoint3D positionToPointAt) {
        origin.changeFrame(this.getParent());
        this.origin.set(origin);
        positionToPointAt.changeFrame(this.getParent());
        this.positionToPointAt.set(positionToPointAt);
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.originVector.set((Tuple3DReadOnly)this.origin);
        this.xAxis.set((Tuple3DReadOnly)this.positionToPointAt);
        this.xAxis.sub((Tuple3DReadOnly)this.originVector);
        double norm = this.xAxis.length();
        if (norm > 1.0E-12) {
            this.xAxis.scale(1.0 / norm);
        } else {
            this.xAxis.set(1.0, 0.0, 0.0);
        }
        this.zAxis.set(0.0, 0.0, 1.0);
        this.yAxis.cross((Tuple3DReadOnly)this.zAxis, (Tuple3DReadOnly)this.xAxis);
        this.yAxis.normalize();
        this.zAxis.cross((Tuple3DReadOnly)this.xAxis, (Tuple3DReadOnly)this.yAxis);
        this.rotationMatrix.setColumns((Tuple3DReadOnly)this.xAxis, (Tuple3DReadOnly)this.yAxis, (Tuple3DReadOnly)this.zAxis);
        transformToParent.setRotationAndZeroTranslation((RotationMatrixReadOnly)this.rotationMatrix);
        transformToParent.getTranslation().set((Tuple3DReadOnly)this.originVector);
    }
}

