/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.quadTree;

import java.util.LinkedHashMap;
import java.util.Map;
import us.ihmc.robotics.quadTree.QuadTreeForGroundPoint;

public class QuadTreeForGroundPointLimiter
extends LinkedHashMap<QuadTreeForGroundPoint, Object> {
    private static final long serialVersionUID = 5582769749269559171L;
    private static final Object PRESENT = new Object();
    private final int maximumSize;

    public QuadTreeForGroundPointLimiter(int maximumSize) {
        super(maximumSize + 1, 1.1f, false);
        this.maximumSize = maximumSize;
    }

    public void add(QuadTreeForGroundPoint point) {
        if (!point.isRegistered()) {
            point.setRegistered(true);
            this.put(point, PRESENT);
        }
    }

    @Override
    public Object remove(Object point) {
        return super.remove(point);
    }

    @Override
    public boolean removeEldestEntry(Map.Entry<QuadTreeForGroundPoint, Object> eldest) {
        if (this.size() > this.maximumSize) {
            QuadTreeForGroundPoint key = eldest.getKey();
            key.removeFromParent();
            return true;
        }
        return false;
    }
}

