/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.quadTree;

import java.util.ArrayList;
import java.util.Collection;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.robotics.quadTree.Box;
import us.ihmc.robotics.quadTree.PointAndDistance;
import us.ihmc.robotics.quadTree.QuadTreeForGroundLeaf;
import us.ihmc.robotics.quadTree.QuadTreeForGroundListener;
import us.ihmc.robotics.quadTree.QuadTreeForGroundParameters;
import us.ihmc.robotics.quadTree.QuadTreeForGroundPoint;
import us.ihmc.robotics.quadTree.QuadTreeForGroundPointLimiter;
import us.ihmc.robotics.quadTree.QuadTreeForGroundPutResult;

public class QuadTreeForGroundNode {
    private final String id;
    private final Box bounds;
    private QuadTreeForGroundLeaf leaf = null;
    private double defaultHeightWhenNoPonts;
    private boolean hasChildren = false;
    private QuadTreeForGroundNode NW = null;
    private QuadTreeForGroundNode NE = null;
    private QuadTreeForGroundNode SE = null;
    private QuadTreeForGroundNode SW = null;
    private final QuadTreeForGroundPointLimiter pointLimiter;
    private final QuadTreeForGroundParameters parameters;
    private final ArrayList<QuadTreeForGroundListener> listeners;
    private final QuadTreeForGroundNode parent;

    public QuadTreeForGroundNode(String id, double minX, double minY, double maxX, double maxY, QuadTreeForGroundParameters parameters, QuadTreeForGroundPointLimiter decay, QuadTreeForGroundNode parent, double defaultHeightWhenNoPonts, ArrayList<QuadTreeForGroundListener> listeners) {
        this(id, new Box(minX, minY, maxX, maxY), parameters, decay, parent, defaultHeightWhenNoPonts, listeners);
    }

    public QuadTreeForGroundNode(String id, Box bounds, QuadTreeForGroundParameters quadTreeParameters, QuadTreeForGroundPointLimiter pointLimiter, QuadTreeForGroundNode parent, double defaultHeightWhenNoPonts, ArrayList<QuadTreeForGroundListener> listeners) {
        this.id = id;
        this.defaultHeightWhenNoPonts = defaultHeightWhenNoPonts;
        this.listeners = listeners;
        this.parameters = quadTreeParameters;
        this.pointLimiter = pointLimiter;
        this.bounds = bounds;
        for (QuadTreeForGroundListener listener : this.listeners) {
            if (Double.isNaN(defaultHeightWhenNoPonts)) continue;
            listener.nodeAdded(id, bounds, (float)(bounds.maxX - bounds.minX), (float)(bounds.maxY - bounds.minY), (float)defaultHeightWhenNoPonts);
        }
        this.parent = parent;
    }

    public void setDefaultHeightWhenNoPoints(double defaultHeightWhenNoPonts) {
        this.defaultHeightWhenNoPonts = defaultHeightWhenNoPonts;
    }

    public double getDefaultHeightWhenNoPoints() {
        return this.defaultHeightWhenNoPonts;
    }

    public void getAllSubTreePoints(Collection<Point3D> pointsToPack) {
        if (this.hasChildren) {
            this.NE.getAllSubTreePoints(pointsToPack);
            this.NW.getAllSubTreePoints(pointsToPack);
            this.SE.getAllSubTreePoints(pointsToPack);
            this.SW.getAllSubTreePoints(pointsToPack);
        } else if (this.leaf != null) {
            this.leaf.getAllPoints(pointsToPack);
        }
    }

    public void getCellAverageSubTreePoints(Collection<Point3D> pointsToPack) {
        if (this.hasChildren) {
            this.NE.getCellAverageSubTreePoints(pointsToPack);
            this.NW.getCellAverageSubTreePoints(pointsToPack);
            this.SE.getCellAverageSubTreePoints(pointsToPack);
            this.SW.getCellAverageSubTreePoints(pointsToPack);
        } else if (this.leaf != null) {
            pointsToPack.add(this.leaf.getAveragePoint());
        }
    }

    public void getAllDescendantNodes(ArrayList<QuadTreeForGroundNode> nodeListToPack) {
        if (this.hasChildren) {
            this.NE.getAllDescendantNodes(nodeListToPack);
            this.NW.getAllDescendantNodes(nodeListToPack);
            this.SE.getAllDescendantNodes(nodeListToPack);
            this.SW.getAllDescendantNodes(nodeListToPack);
        } else {
            nodeListToPack.add(this);
        }
    }

    public void getChildrenNodes(ArrayList<QuadTreeForGroundNode> childrenToPack) {
        if (this.hasChildren) {
            childrenToPack.add(this.NW);
            childrenToPack.add(this.NE);
            childrenToPack.add(this.SE);
            childrenToPack.add(this.SW);
        }
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public boolean isEmpty() {
        return !this.hasChildren && this.leaf == null;
    }

    public QuadTreeForGroundPutResult put(QuadTreeForGroundPoint point) {
        if (this.hasChildren) {
            QuadTreeForGroundPutResult putResult = this.getChild(point.getX(), point.getY()).put(point);
            return putResult;
        }
        if (this.leaf == null) {
            QuadTreeForGroundLeaf leaf = new QuadTreeForGroundLeaf(this, this.pointLimiter);
            leaf.addPoint(point);
            this.setLeaf(leaf);
            for (QuadTreeForGroundListener listener : this.listeners) {
                listener.nodeRemoved(this.id);
                listener.nodeAdded(this.id, this.bounds, (float)point.getX(), (float)point.getY(), (float)point.getZ());
            }
            QuadTreeForGroundPutResult quadTreePutResult = this.createNewResult();
            quadTreePutResult.addNode = true;
            quadTreePutResult.treeChanged = true;
            return quadTreePutResult;
        }
        if (this.isAtSmallestResolution()) {
            boolean updateChangedTree = this.updateLeafValueIfHeightIsAppropriate(point);
            QuadTreeForGroundPutResult quadTreePutResult = this.createNewResult();
            quadTreePutResult.treeChanged = updateChangedTree;
            if (updateChangedTree) {
                for (QuadTreeForGroundListener listener : this.listeners) {
                    Point3D averagePoint = this.leaf.getAveragePoint();
                    listener.nodeRemoved(this.id);
                    listener.nodeAdded(this.id, this.bounds, (float)averagePoint.getX(), (float)averagePoint.getY(), (float)averagePoint.getZ());
                }
                quadTreePutResult.changedNode = true;
                quadTreePutResult.treeChanged = true;
            } else {
                quadTreePutResult.changedNode = false;
                quadTreePutResult.treeChanged = false;
            }
            return quadTreePutResult;
        }
        if (this.isNotYetAtResonableResolution()) {
            this.divide();
            return this.put(point);
        }
        Point3D averagePoint = this.leaf.getAveragePoint();
        if (Math.abs(averagePoint.getZ() - point.getZ()) < this.parameters.getHeightThreshold()) {
            this.updateLeafValue(point);
            QuadTreeForGroundPutResult quadTreePutResult = this.createNewResult();
            return quadTreePutResult;
        }
        this.divide();
        return this.put(point);
    }

    public String getID() {
        return this.id;
    }

    private boolean isAtSmallestResolution() {
        return Math.abs(this.bounds.maxX - this.bounds.minX) < this.parameters.getResolution();
    }

    private boolean isNotYetAtResonableResolution() {
        return Math.abs(this.bounds.maxX - this.bounds.minX) > 4.1 * this.parameters.getResolution();
    }

    public Box getBounds() {
        return this.bounds;
    }

    public void clear() {
        if (this.hasChildren) {
            this.NW.clear();
            this.NE.clear();
            this.SE.clear();
            this.SW.clear();
            this.NW = null;
            this.NE = null;
            this.SE = null;
            this.SW = null;
            this.hasChildren = false;
        } else {
            for (QuadTreeForGroundListener listener : this.listeners) {
                listener.nodeRemoved(this.getID());
            }
            if (this.leaf != null) {
                this.leaf.clear();
                this.setLeaf(null);
            }
        }
    }

    public void getClosestPoint(double xQuery, double yQuery, Point3D pointToPack) {
        PointAndDistance pointAndDistance = new PointAndDistance(pointToPack, Double.POSITIVE_INFINITY);
        this.getClosestPointAndDistance(xQuery, yQuery, pointAndDistance);
    }

    public void getClosestPointAndDistance(double x, double y, PointAndDistance bestSoFarToUpdate) {
        if (x < this.bounds.minX - bestSoFarToUpdate.getDistance() || x > this.bounds.maxX + bestSoFarToUpdate.getDistance() || y < this.bounds.minY - bestSoFarToUpdate.getDistance() || y > this.bounds.maxY + bestSoFarToUpdate.getDistance()) {
            return;
        }
        if (this.hasChildren) {
            QuadTreeForGroundNode childAtXY = this.getChild(x, y);
            if (childAtXY != null) {
                childAtXY.getClosestPointAndDistance(x, y, bestSoFarToUpdate);
            }
            if (this.NE != childAtXY) {
                this.NE.getClosestPointAndDistance(x, y, bestSoFarToUpdate);
            }
            if (this.NW != childAtXY) {
                this.NW.getClosestPointAndDistance(x, y, bestSoFarToUpdate);
            }
            if (this.SE != childAtXY) {
                this.SE.getClosestPointAndDistance(x, y, bestSoFarToUpdate);
            }
            if (this.SW != childAtXY) {
                this.SW.getClosestPointAndDistance(x, y, bestSoFarToUpdate);
            }
        } else if (this.leaf != null) {
            if (this.isAtSmallestResolution()) {
                this.leaf.getClosestPointAndDistanceUsingAverage(x, y, bestSoFarToUpdate);
            } else {
                this.leaf.getClosestPointAndDistanceUsingAverageHeight(x, y, bestSoFarToUpdate);
            }
        }
    }

    public void getAllPointsWithinDistance(double x, double y, double maxDistance, ArrayList<Point3D> pointsWithinDistanceToPack) {
        if (maxDistance < 0.0) {
            return;
        }
        if (this.hasChildren) {
            if (this.NW.bounds.calcDist(x, y) <= maxDistance) {
                this.NW.getAllPointsWithinDistance(x, y, maxDistance, pointsWithinDistanceToPack);
            }
            if (this.NE.bounds.calcDist(x, y) <= maxDistance) {
                this.NE.getAllPointsWithinDistance(x, y, maxDistance, pointsWithinDistanceToPack);
            }
            if (this.SE.bounds.calcDist(x, y) <= maxDistance) {
                this.SE.getAllPointsWithinDistance(x, y, maxDistance, pointsWithinDistanceToPack);
            }
            if (this.SW.bounds.calcDist(x, y) <= maxDistance) {
                this.SW.getAllPointsWithinDistance(x, y, maxDistance, pointsWithinDistanceToPack);
            }
            return;
        }
        if (this.leaf != null) {
            this.leaf.getAllPointsWithinDistance(x, y, maxDistance, pointsWithinDistanceToPack);
        }
    }

    public void getAllPointsWithBounds(Box bounds, ArrayList<Point3D> pointsWithinBoundsToPack) {
        if (this.hasChildren) {
            if (this.NW.bounds.intersects(bounds)) {
                this.NW.getAllPointsWithBounds(bounds, pointsWithinBoundsToPack);
            }
            if (this.NE.bounds.intersects(bounds)) {
                this.NE.getAllPointsWithBounds(bounds, pointsWithinBoundsToPack);
            }
            if (this.SE.bounds.intersects(bounds)) {
                this.SE.getAllPointsWithBounds(bounds, pointsWithinBoundsToPack);
            }
            if (this.SW.bounds.intersects(bounds)) {
                this.SW.getAllPointsWithBounds(bounds, pointsWithinBoundsToPack);
            }
        } else if (this.leaf != null) {
            if (bounds.containsOrEquals(this.bounds)) {
                this.leaf.getAllPoints(pointsWithinBoundsToPack);
            } else {
                this.leaf.getAllPointsWithinBounds(bounds, pointsWithinBoundsToPack);
            }
        }
    }

    private void divide() {
        for (QuadTreeForGroundListener listener : this.listeners) {
            listener.nodeRemoved(this.id);
        }
        this.NW = new QuadTreeForGroundNode(this.id + "NW", this.bounds.minX, this.bounds.centreY, this.bounds.centreX, this.bounds.maxY, this.parameters, this.pointLimiter, this, this.defaultHeightWhenNoPonts, this.listeners);
        this.NE = new QuadTreeForGroundNode(this.id + "NE", this.bounds.centreX, this.bounds.centreY, this.bounds.maxX, this.bounds.maxY, this.parameters, this.pointLimiter, this, this.defaultHeightWhenNoPonts, this.listeners);
        this.SE = new QuadTreeForGroundNode(this.id + "SE", this.bounds.centreX, this.bounds.minY, this.bounds.maxX, this.bounds.centreY, this.parameters, this.pointLimiter, this, this.defaultHeightWhenNoPonts, this.listeners);
        this.SW = new QuadTreeForGroundNode(this.id + "SW", this.bounds.minX, this.bounds.minY, this.bounds.centreX, this.bounds.centreY, this.parameters, this.pointLimiter, this, this.defaultHeightWhenNoPonts, this.listeners);
        this.hasChildren = true;
        if (this.leaf != null) {
            ArrayList<QuadTreeForGroundPoint> points = this.leaf.getPoints();
            if (points != null) {
                for (QuadTreeForGroundPoint point3d : points) {
                    this.put(point3d);
                }
            }
            this.setLeaf(null);
        }
    }

    private QuadTreeForGroundNode getChild(double x, double y) {
        if (this.hasChildren) {
            if (x < this.bounds.centreX) {
                if (y < this.bounds.centreY) {
                    return this.SW;
                }
                return this.NW;
            }
            if (y < this.bounds.centreY) {
                return this.SE;
            }
            return this.NE;
        }
        return null;
    }

    public int getNumberOfChildren() {
        int count = 0;
        if (this.hasChildren) {
            if (this.NE != null) {
                count += this.NE.getNumberOfChildren();
            }
            if (this.NW != null) {
                count += this.NW.getNumberOfChildren();
            }
            if (this.SE != null) {
                count += this.SE.getNumberOfChildren();
            }
            if (this.SW != null) {
                count += this.SW.getNumberOfChildren();
            }
        } else {
            count = 1;
        }
        return count;
    }

    protected QuadTreeForGroundPutResult createNewResult() {
        return new QuadTreeForGroundPutResult();
    }

    protected void setLeaf(QuadTreeForGroundLeaf leaf) {
        this.leaf = leaf;
    }

    public QuadTreeForGroundLeaf getLeaf() {
        return this.leaf;
    }

    private double getAverageHeightOfLeaf() {
        Point3D averagePoint = this.leaf.getAveragePoint();
        return averagePoint.getZ();
    }

    private boolean updateLeafValueIfHeightIsAppropriate(QuadTreeForGroundPoint point) {
        double heightDifference = point.getZ() - this.getAverageHeightOfLeaf();
        if (heightDifference > 0.0 && heightDifference < this.parameters.getMaxMultiLevelZChangeToFilterNoise()) {
            this.updateLeafValue(point);
            return true;
        }
        if (heightDifference < 0.0 && Math.abs(heightDifference) > this.parameters.getMaxMultiLevelZChangeToFilterNoise()) {
            this.updateLeafValue(point);
            return true;
        }
        return false;
    }

    private void updateLeafValue(QuadTreeForGroundPoint point) {
        if (this.leaf.getNumberOfPoints() < this.parameters.getMaxSameHeightPointsPerNode()) {
            this.leaf.addPoint(point);
        } else {
            this.leaf.replaceLeastRecentPoint(point);
        }
    }

    public void checkRepInvarients() {
        boolean isLeaf;
        boolean bl = isLeaf = this.leaf != null;
        if (isLeaf) {
            if (this.hasChildren) {
                throw new RuntimeException();
            }
            if (this.NE != null) {
                throw new RuntimeException();
            }
            if (this.NW != null) {
                throw new RuntimeException();
            }
            if (this.SE != null) {
                throw new RuntimeException();
            }
            if (this.SW != null) {
                throw new RuntimeException();
            }
            this.leaf.checkRepInvarients(this.bounds);
        }
        if (!this.hasChildren) {
            if (this.NE != null) {
                throw new RuntimeException();
            }
            if (this.NW != null) {
                throw new RuntimeException();
            }
            if (this.SE != null) {
                throw new RuntimeException();
            }
            if (this.SW != null) {
                throw new RuntimeException();
            }
        } else {
            this.bounds.containsOrEquals(this.NE.bounds);
            this.bounds.containsOrEquals(this.NW.bounds);
            this.bounds.containsOrEquals(this.SE.bounds);
            this.bounds.containsOrEquals(this.SW.bounds);
            this.NE.checkRepInvarients();
            this.NW.checkRepInvarients();
            this.SE.checkRepInvarients();
            this.SW.checkRepInvarients();
        }
    }

    public String toString() {
        return "QuadNode{bounds=" + this.bounds + ", leaf=" + this.leaf + ", hasChildren=" + this.hasChildren + '}';
    }

    public void merge() {
        if (this.hasChildren) {
            if (this.NE.isEmpty() && this.NW.isEmpty() && this.SE.isEmpty() && this.SW.isEmpty()) {
                this.NE = null;
                this.NW = null;
                this.SE = null;
                this.SW = null;
                this.hasChildren = false;
                this.parent.merge();
            }
        } else {
            this.leaf = null;
            this.parent.merge();
        }
    }

    public QuadTreeForGroundPutResult put(double x, double y, double z) {
        QuadTreeForGroundPoint point = new QuadTreeForGroundPoint(x, y, z);
        return this.put(point);
    }
}

