/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.multiBodySystem.SphericalJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointBasics;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class SingleRobotFirstOrderIntegrator {
    private MultiBodySystemBasics input;
    private final DMatrixRMaj velocityChangeMatrix;
    private final Vector3D deltaPosition = new Vector3D();
    private final Vector3D rotationVector = new Vector3D();
    private final Quaternion orientationChange = new Quaternion();
    private final FrameVector3D linearAcceleration = new FrameVector3D();
    private final SpatialVector spatialVelocityChange = new SpatialVector();
    private final FrameVector3D angularVelocityChange = new FrameVector3D();
    private final RigidBodyTwistChangeCalculator rigidBodyTwistChangeCalculator;
    private final RigidBodyTwistProvider rigidBodyTwistChangeProvider;

    public SingleRobotFirstOrderIntegrator(MultiBodySystemBasics input) {
        this.input = input;
        this.velocityChangeMatrix = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((List)input.getAllJoints()), 1);
        this.rigidBodyTwistChangeCalculator = new RigidBodyTwistChangeCalculator();
        this.rigidBodyTwistChangeProvider = RigidBodyTwistProvider.toRigidBodyTwistProvider((Function)this.rigidBodyTwistChangeCalculator, (ReferenceFrame)input.getInertialFrame());
    }

    public void reset() {
        this.velocityChangeMatrix.zero();
        this.rigidBodyTwistChangeCalculator.reset();
    }

    public void setJointVelocityChange(DMatrixRMaj velocityChange) {
        if (velocityChange == null) {
            return;
        }
        this.velocityChangeMatrix.set((DMatrixD1)velocityChange);
    }

    public void addJointVelocityChange(DMatrixRMaj velocityChange) {
        if (velocityChange == null) {
            return;
        }
        CommonOps_DDRM.addEquals((DMatrixD1)this.velocityChangeMatrix, (DMatrixD1)velocityChange);
    }

    public void integrate(double dt) {
        List jointsToConsider = this.input.getJointsToConsider();
        int startIndex = 0;
        for (JointBasics joint : jointsToConsider) {
            if (joint instanceof OneDoFJointBasics) {
                double velocityChange = this.velocityChangeMatrix.get(startIndex);
                this.integrateOneDoFJoint(dt, (OneDoFJointBasics)joint, velocityChange);
            } else if (joint instanceof SixDoFJointBasics) {
                this.spatialVelocityChange.setIncludingFrame((ReferenceFrame)joint.getFrameAfterJoint(), startIndex, (DMatrix)this.velocityChangeMatrix);
                this.integrateFloatingJoint(dt, (FloatingJointBasics)((SixDoFJointBasics)joint), (SpatialVectorReadOnly)this.spatialVelocityChange);
            } else if (joint instanceof SphericalJoint) {
                this.angularVelocityChange.setIncludingFrame((ReferenceFrame)joint.getFrameAfterJoint(), startIndex, (DMatrix)this.velocityChangeMatrix);
                this.integrateSphericalJoint(dt, (SphericalJointBasics)joint, (FrameVector3DReadOnly)this.angularVelocityChange);
            } else {
                throw new UnsupportedOperationException("Unsupported joint " + joint);
            }
            startIndex += joint.getDegreesOfFreedom();
        }
    }

    public void integrateOneDoFJoint(double dt, OneDoFJointBasics joint, double velocityChange) {
        double qdd = joint.getQdd();
        double qd = joint.getQd() + qdd * dt + velocityChange;
        double q = joint.getQ() + (joint.getQd() + 0.5 * velocityChange) * dt + 0.5 * joint.getQdd() * dt * dt;
        joint.setQ(q);
        joint.setQd(qd);
        joint.setQdd(qdd);
    }

    public void integrateSphericalJoint(double dt, SphericalJointBasics joint, FrameVector3DReadOnly angularVelocityChange) {
        QuaternionBasics orientation = joint.getJointOrientation();
        FixedFrameVector3DBasics angularVelocity = joint.getJointAngularVelocity();
        FixedFrameVector3DBasics angularAcceleration = joint.getJointAngularAcceleration();
        this.rotationVector.setAndScale(dt, (Tuple3DReadOnly)angularVelocity);
        this.rotationVector.scaleAdd(0.5 * dt, (Tuple3DReadOnly)angularVelocityChange, (Tuple3DReadOnly)this.rotationVector);
        this.rotationVector.scaleAdd(0.5 * dt * dt, (Tuple3DReadOnly)angularAcceleration, (Tuple3DReadOnly)this.rotationVector);
        this.orientationChange.setRotationVector((Vector3DReadOnly)this.rotationVector);
        angularVelocity.scaleAdd(dt, (FrameTuple3DReadOnly)angularAcceleration, (FrameTuple3DReadOnly)angularVelocity);
        angularVelocity.add((FrameTuple3DReadOnly)angularVelocityChange);
        orientation.append((Orientation3DReadOnly)this.orientationChange);
    }

    public void integrateFloatingJoint(double dt, FloatingJointBasics joint, SpatialVectorReadOnly spatialVelocityChange) {
        FrameVector3DReadOnly angularVelocityChange = spatialVelocityChange.getAngularPart();
        FrameVector3DReadOnly linearVelocityChange = spatialVelocityChange.getLinearPart();
        Pose3DBasics pose = joint.getJointPose();
        QuaternionBasics orientation = pose.getOrientation();
        Point3DBasics position = pose.getPosition();
        FixedFrameTwistBasics twist = joint.getJointTwist();
        FixedFrameVector3DBasics angularVelocity = twist.getAngularPart();
        FixedFrameVector3DBasics linearVelocity = twist.getLinearPart();
        FixedFrameSpatialAccelerationBasics spatialAcceleration = joint.getJointAcceleration();
        FixedFrameVector3DBasics angularAcceleration = spatialAcceleration.getAngularPart();
        spatialAcceleration.getLinearAccelerationAtBodyOrigin((TwistReadOnly)twist, (FrameVector3DBasics)this.linearAcceleration);
        this.rotationVector.setAndScale(dt, (Tuple3DReadOnly)angularVelocity);
        this.rotationVector.scaleAdd(0.5 * dt, (Tuple3DReadOnly)angularVelocityChange, (Tuple3DReadOnly)this.rotationVector);
        this.rotationVector.scaleAdd(0.5 * dt * dt, (Tuple3DReadOnly)angularAcceleration, (Tuple3DReadOnly)this.rotationVector);
        this.orientationChange.setRotationVector((Vector3DReadOnly)this.rotationVector);
        angularVelocity.scaleAdd(dt, (FrameTuple3DReadOnly)angularAcceleration, (FrameTuple3DReadOnly)angularVelocity);
        angularVelocity.add((FrameTuple3DReadOnly)angularVelocityChange);
        this.deltaPosition.setAndScale(dt, (Tuple3DReadOnly)linearVelocity);
        this.deltaPosition.scaleAdd(0.5 * dt, (Tuple3DReadOnly)linearVelocityChange, (Tuple3DReadOnly)this.deltaPosition);
        this.deltaPosition.scaleAdd(0.5 * dt * dt, (Tuple3DReadOnly)this.linearAcceleration, (Tuple3DReadOnly)this.deltaPosition);
        orientation.transform((Tuple3DBasics)this.deltaPosition);
        position.add((Tuple3DReadOnly)this.deltaPosition);
        linearVelocity.scaleAdd(dt, (FrameTuple3DReadOnly)this.linearAcceleration, (FrameTuple3DReadOnly)linearVelocity);
        linearVelocity.add((FrameTuple3DReadOnly)linearVelocityChange);
        this.orientationChange.inverseTransform((Tuple3DBasics)linearVelocity);
        this.orientationChange.inverseTransform((Tuple3DBasics)this.linearAcceleration);
        spatialAcceleration.setBasedOnOriginAcceleration((FrameVector3DReadOnly)angularAcceleration, (FrameVector3DReadOnly)this.linearAcceleration, (TwistReadOnly)twist);
        orientation.append((Orientation3DReadOnly)this.orientationChange);
    }

    public RigidBodyTwistProvider getRigidBodyTwistChangeProvider() {
        return this.rigidBodyTwistChangeProvider;
    }

    private class RigidBodyTwistChangeCalculator
    implements Function<RigidBodyReadOnly, TwistReadOnly> {
        private final Map<RigidBodyReadOnly, Twist> rigidBodyTwistMap = new HashMap<RigidBodyReadOnly, Twist>();
        private final Twist jointTwist = new Twist();
        private final JointMatrixIndexProvider jointMatrixIndexProvider = SingleRobotFirstOrderIntegrator.access$100(SingleRobotFirstOrderIntegrator.this).getJointMatrixIndexProvider();

        private RigidBodyTwistChangeCalculator() {
        }

        public void reset() {
            this.rigidBodyTwistMap.clear();
        }

        @Override
        public TwistReadOnly apply(RigidBodyReadOnly body) {
            Twist twistOfBody = this.rigidBodyTwistMap.get(body);
            if (twistOfBody == null) {
                JointReadOnly parentJoint = body.getParentJoint();
                RigidBodyReadOnly parentBody = parentJoint.getPredecessor();
                TwistReadOnly twistOfParentBody = parentBody.isRootBody() ? null : this.apply(parentBody);
                if (parentJoint instanceof OneDoFJointReadOnly) {
                    this.jointTwist.setIncludingFrame((SpatialMotionReadOnly)((OneDoFJointReadOnly)parentJoint).getUnitJointTwist());
                    this.jointTwist.scale(SingleRobotFirstOrderIntegrator.this.velocityChangeMatrix.get(this.jointMatrixIndexProvider.getJointDoFIndices(parentJoint)[0]));
                } else if (parentJoint instanceof SixDoFJointReadOnly) {
                    this.jointTwist.set(this.jointMatrixIndexProvider.getJointDoFIndices(parentJoint)[0], (DMatrix)SingleRobotFirstOrderIntegrator.this.velocityChangeMatrix);
                    this.jointTwist.setReferenceFrame((ReferenceFrame)parentJoint.getFrameAfterJoint());
                    this.jointTwist.setBaseFrame((ReferenceFrame)parentJoint.getFrameBeforeJoint());
                    this.jointTwist.setBodyFrame((ReferenceFrame)parentJoint.getFrameAfterJoint());
                } else {
                    throw new UnsupportedOperationException("Implement me for: " + parentJoint.getClass().getSimpleName());
                }
                this.jointTwist.changeFrame((ReferenceFrame)body.getBodyFixedFrame());
                this.jointTwist.setBaseFrame((ReferenceFrame)parentBody.getBodyFixedFrame());
                this.jointTwist.setBodyFrame((ReferenceFrame)body.getBodyFixedFrame());
                twistOfBody = new Twist();
                if (twistOfParentBody == null) {
                    twistOfBody.setToZero((ReferenceFrame)parentBody.getBodyFixedFrame(), SingleRobotFirstOrderIntegrator.this.input.getInertialFrame(), (ReferenceFrame)parentBody.getBodyFixedFrame());
                } else {
                    twistOfBody.setIncludingFrame((SpatialMotionReadOnly)twistOfParentBody);
                }
                twistOfBody.changeFrame((ReferenceFrame)body.getBodyFixedFrame());
                twistOfBody.add((TwistReadOnly)this.jointTwist);
                this.rigidBodyTwistMap.put(body, twistOfBody);
            }
            return twistOfBody;
        }
    }
}

