/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.physics.Collidable;

public interface RobotCollisionModel {
    default public List<Collidable> getRobotCollidables(RigidBodyBasics rootBody) {
        return this.getRobotCollidables(MultiBodySystemBasics.toMultiBodySystemBasics((RigidBodyBasics)rootBody));
    }

    public List<Collidable> getRobotCollidables(MultiBodySystemBasics var1);

    public static RigidBodyBasics findRigidBody(String name, MultiBodySystemBasics multiBodySystem) {
        return multiBodySystem.getRootBody().subtreeStream().filter(body -> body.getName().equals(name)).findAny().orElse(null);
    }

    public static JointBasics findJoint(String name, MultiBodySystemBasics multiBodySystem) {
        return multiBodySystem.getAllJoints().stream().filter(joint -> joint.getName().equals(name)).findAny().orElse(null);
    }

    public static RobotCollisionModel singleBodyCollisionModel(String bodyName, Function<RigidBodyBasics, Collidable> collidableBuilder) {
        return multiBodySystem -> Collections.singletonList(collidableBuilder.apply(RobotCollisionModel.findRigidBody(bodyName, multiBodySystem)));
    }
}

