/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.physics.Collidable;
import us.ihmc.robotics.physics.CollidableHolder;
import us.ihmc.robotics.physics.FrameShapePosePredictor;
import us.ihmc.robotics.physics.MultiBodySystemStateReader;
import us.ihmc.robotics.physics.MultiBodySystemStateWriter;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.physics.RobotJointLimitImpulseBasedCalculator;
import us.ihmc.robotics.physics.SingleContactImpulseCalculator;
import us.ihmc.robotics.physics.SingleRobotFirstOrderIntegrator;
import us.ihmc.robotics.physics.SingleRobotForwardDynamicsPlugin;
import us.ihmc.robotics.physics.YoRobotJointLimitImpulseBasedCalculator;
import us.ihmc.robotics.physics.YoSingleContactImpulseCalculatorPool;
import us.ihmc.yoVariables.registry.YoRegistry;

public class PhysicsEngineRobotData
implements CollidableHolder {
    private static final String ContactCalculatorNameSuffix = SingleContactImpulseCalculator.class.getSimpleName();
    private final String robotName;
    private final RigidBodyBasics rootBody;
    private MultiBodySystemStateWriter robotInitialStateWriter;
    private final List<MultiBodySystemStateWriter> physicsInputStateWriters = new ArrayList<MultiBodySystemStateWriter>();
    private final List<MultiBodySystemStateReader> physicsOutputStateReaders = new ArrayList<MultiBodySystemStateReader>();
    private final YoRegistry robotRegistry;
    private final YoRegistry environmentContactCalculatorRegistry = new YoRegistry("Environment" + ContactCalculatorNameSuffix);
    private final YoRegistry interRobotContactCalculatorRegistry = new YoRegistry("InterRobot" + ContactCalculatorNameSuffix);
    private final YoRegistry selfContactCalculatorRegistry = new YoRegistry("Self" + ContactCalculatorNameSuffix);
    private final MultiBodySystemBasics multiBodySystem;
    private final List<Collidable> collidables;
    private final SingleRobotForwardDynamicsPlugin forwardDynamicsPlugin;
    private final RobotJointLimitImpulseBasedCalculator jointLimitConstraintCalculator;
    private final YoSingleContactImpulseCalculatorPool environmentContactConstraintCalculatorPool;
    private final YoSingleContactImpulseCalculatorPool selfContactConstraintCalculatorPool;
    private final Map<RigidBodyBasics, YoSingleContactImpulseCalculatorPool> interRobotContactConstraintCalculatorPools = new HashMap<RigidBodyBasics, YoSingleContactImpulseCalculatorPool>();
    private final SingleRobotFirstOrderIntegrator integrator;

    public PhysicsEngineRobotData(String robotName, RigidBodyBasics rootBody, RobotCollisionModel robotCollisionModel, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.robotName = robotName;
        this.rootBody = rootBody;
        this.robotRegistry = new YoRegistry(robotName);
        this.multiBodySystem = MultiBodySystemBasics.toMultiBodySystemBasics((RigidBodyBasics)rootBody);
        this.collidables = robotCollisionModel != null ? robotCollisionModel.getRobotCollidables(this.multiBodySystem) : Collections.emptyList();
        this.forwardDynamicsPlugin = new SingleRobotForwardDynamicsPlugin(this.multiBodySystem);
        FrameShapePosePredictor frameShapePosePredictor = new FrameShapePosePredictor(this.forwardDynamicsPlugin.getForwardDynamicsCalculator());
        this.collidables.forEach(collidable -> collidable.setFrameShapePosePredictor(frameShapePosePredictor));
        YoRegistry jointLimitConstraintCalculatorRegistry = new YoRegistry(RobotJointLimitImpulseBasedCalculator.class.getSimpleName());
        this.robotRegistry.addChild(jointLimitConstraintCalculatorRegistry);
        this.jointLimitConstraintCalculator = new YoRobotJointLimitImpulseBasedCalculator(rootBody, this.forwardDynamicsPlugin.getForwardDynamicsCalculator(), jointLimitConstraintCalculatorRegistry);
        this.robotRegistry.addChild(this.environmentContactCalculatorRegistry);
        this.robotRegistry.addChild(this.interRobotContactCalculatorRegistry);
        this.robotRegistry.addChild(this.selfContactCalculatorRegistry);
        this.environmentContactConstraintCalculatorPool = new YoSingleContactImpulseCalculatorPool(20, robotName + "Single", this.multiBodySystem.getInertialFrame(), rootBody, this.forwardDynamicsPlugin.getForwardDynamicsCalculator(), null, null, yoGraphicsListRegistry, this.environmentContactCalculatorRegistry);
        this.selfContactConstraintCalculatorPool = new YoSingleContactImpulseCalculatorPool(8, robotName + "Self", this.multiBodySystem.getInertialFrame(), rootBody, this.forwardDynamicsPlugin.getForwardDynamicsCalculator(), rootBody, this.forwardDynamicsPlugin.getForwardDynamicsCalculator(), yoGraphicsListRegistry, this.selfContactCalculatorRegistry);
        this.integrator = new SingleRobotFirstOrderIntegrator(this.multiBodySystem);
    }

    public void setControllerOutputWriter(MultiBodySystemStateWriter controllerOutputWriter) {
        if (controllerOutputWriter != null) {
            controllerOutputWriter.setMultiBodySystem(this.multiBodySystem);
        }
        this.forwardDynamicsPlugin.setControllerOutputWriter(controllerOutputWriter);
    }

    public void setRobotInitialStateWriter(MultiBodySystemStateWriter robotInitialStateWriter) {
        this.robotInitialStateWriter = robotInitialStateWriter;
        this.setControllerOutputWriter(robotInitialStateWriter);
    }

    public void addPhysicsInputStateWriter(MultiBodySystemStateWriter physicsInputStateWriter) {
        if (physicsInputStateWriter == null) {
            return;
        }
        physicsInputStateWriter.setMultiBodySystem(this.multiBodySystem);
        this.physicsInputStateWriters.add(physicsInputStateWriter);
    }

    public void addPhysicsOutputStateReader(MultiBodySystemStateReader physicsOutputStateReader) {
        if (physicsOutputStateReader == null) {
            return;
        }
        physicsOutputStateReader.setMultiBodySystem((MultiBodySystemReadOnly)this.multiBodySystem);
        this.physicsOutputStateReaders.add(physicsOutputStateReader);
    }

    public void initialize() {
        if (this.robotInitialStateWriter != null) {
            this.robotInitialStateWriter.write();
        }
        this.updateFrames();
    }

    public boolean notifyPhysicsInputStateWriters() {
        boolean stateChanged = false;
        for (MultiBodySystemStateWriter stateWriter : this.physicsInputStateWriters) {
            stateChanged |= stateWriter.write();
        }
        return stateChanged;
    }

    public void notifyPhysicsOutputStateReaders() {
        this.physicsOutputStateReaders.forEach(MultiBodySystemStateReader::read);
    }

    public void updateCollidableBoundingBoxes() {
        this.collidables.forEach(collidable -> collidable.updateBoundingBox(this.multiBodySystem.getInertialFrame()));
    }

    public void updateFrames() {
        this.rootBody.updateFramesRecursively();
    }

    @Override
    public List<Collidable> getCollidables() {
        return this.collidables;
    }

    public String getRobotName() {
        return this.robotName;
    }

    public RigidBodyBasics getRootBody() {
        return this.rootBody;
    }

    public MultiBodySystemBasics getMultiBodySystem() {
        return this.multiBodySystem;
    }

    public SingleRobotForwardDynamicsPlugin getForwardDynamicsPlugin() {
        return this.forwardDynamicsPlugin;
    }

    public SingleRobotFirstOrderIntegrator getIntegrator() {
        return this.integrator;
    }

    public void resetCalculators() {
        this.environmentContactConstraintCalculatorPool.clear();
        this.selfContactConstraintCalculatorPool.clear();
        this.interRobotContactConstraintCalculatorPools.forEach((? super K rigidBodyBasics, ? super V calculators) -> calculators.clear());
        this.integrator.reset();
    }

    public RobotJointLimitImpulseBasedCalculator getJointLimitConstraintCalculator() {
        return this.jointLimitConstraintCalculator;
    }

    public SingleContactImpulseCalculator getOrCreateEnvironmentContactConstraintCalculator() {
        return this.environmentContactConstraintCalculatorPool.nextAvailable();
    }

    public YoSingleContactImpulseCalculatorPool getEnvironmentContactConstraintCalculatorPool() {
        return this.environmentContactConstraintCalculatorPool;
    }

    public YoSingleContactImpulseCalculatorPool getSelfContactConstraintCalculatorPool() {
        return this.selfContactConstraintCalculatorPool;
    }

    public SingleContactImpulseCalculator getOrCreateSelfContactConstraintCalculator() {
        return this.selfContactConstraintCalculatorPool.nextAvailable();
    }

    public SingleContactImpulseCalculator getOrCreateInterRobotContactConstraintCalculator(PhysicsEngineRobotData otherRobot) {
        if (otherRobot == null) {
            return this.getOrCreateEnvironmentContactConstraintCalculator();
        }
        if (otherRobot == this) {
            return this.getOrCreateSelfContactConstraintCalculator();
        }
        YoSingleContactImpulseCalculatorPool calculators = this.interRobotContactConstraintCalculatorPools.get(otherRobot.getRootBody());
        if (calculators == null) {
            calculators = new YoSingleContactImpulseCalculatorPool(8, this.robotName + otherRobot.getRobotName() + "Dual", this.multiBodySystem.getInertialFrame(), this.rootBody, this.forwardDynamicsPlugin.getForwardDynamicsCalculator(), otherRobot.getRootBody(), otherRobot.getForwardDynamicsPlugin().getForwardDynamicsCalculator(), null, this.interRobotContactCalculatorRegistry);
            this.interRobotContactConstraintCalculatorPools.put(otherRobot.getRootBody(), calculators);
        }
        return calculators.nextAvailable();
    }

    public YoRegistry getRobotRegistry() {
        return this.robotRegistry;
    }
}

