/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.robotics.physics.RobotCollisionModel;

public interface MultiBodySystemStateWriter {
    public void setMultiBodySystem(MultiBodySystemBasics var1);

    public boolean write();

    public static <T extends JointBasics> MultiBodySystemStateWriter singleJointStateWriter(final String jointName, final Consumer<T> jointStateWriter) {
        return new MultiBodySystemStateWriter(){
            private T joint;

            @Override
            public boolean write() {
                jointStateWriter.accept(this.joint);
                return true;
            }

            @Override
            public void setMultiBodySystem(MultiBodySystemBasics multiBodySystem) {
                this.joint = RobotCollisionModel.findJoint(jointName, multiBodySystem);
            }
        };
    }

    public static abstract class MapBasedJointStateWriter
    implements MultiBodySystemStateWriter {
        private final Map<String, JointBasics> jointMap = new HashMap<String, JointBasics>();

        public <T extends JointBasics> T getJoint(String jointName) {
            return (T)this.jointMap.get(jointName);
        }

        @Override
        public void setMultiBodySystem(MultiBodySystemBasics multiBodySystem) {
            for (JointBasics joint : multiBodySystem.getAllJoints()) {
                this.jointMap.put(joint.getName(), joint);
            }
        }
    }
}

