/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.physics.Collidable;
import us.ihmc.robotics.physics.CollidableVisualizer;
import us.ihmc.robotics.physics.CollisionListResult;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CollidableListVisualizer {
    private static final String staticCollidableName = "environment";
    private final String groupName;
    private final AppearanceDefinition appearanceDefinition;
    private final YoRegistry registry;
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private int staticCollidableCounter = 0;
    private final TObjectIntHashMap<RigidBodyBasics> rigidBodyCollidableCounterMap = new TObjectIntHashMap();
    private final Map<Collidable, CollidableVisualizer> collidableVisualizerMap = new HashMap<Collidable, CollidableVisualizer>();

    public CollidableListVisualizer(String groupName, AppearanceDefinition appearanceDefinition, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.groupName = groupName;
        this.appearanceDefinition = appearanceDefinition;
        this.registry = registry;
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
    }

    public void addCollidable(Collidable collidable) {
        String name;
        if (collidable.getRigidBody() == null) {
            name = staticCollidableName + Integer.toString(this.staticCollidableCounter++);
        } else {
            int counter = this.rigidBodyCollidableCounterMap.adjustOrPutValue((Object)collidable.getRigidBody(), 1, 0);
            name = collidable.getRigidBody().getName() + Integer.toString(counter);
        }
        try {
            CollidableVisualizer collidableVisualizer = new CollidableVisualizer(name, this.groupName, collidable, this.appearanceDefinition, this.registry, this.yoGraphicsListRegistry);
            this.collidableVisualizerMap.put(collidable, collidableVisualizer);
        }
        catch (UnsupportedOperationException e) {
            LogTools.error((String)e.getMessage());
        }
    }

    public void update(CollisionListResult collisionListResult) {
        this.update(collisionListResult.stream().filter(collisionResult -> collisionResult.getCollisionData().areShapesColliding()).flatMap(collisionResult -> Stream.of(collisionResult.getCollidableA(), collisionResult.getCollidableB())).collect(Collectors.toList()));
    }

    public void update(Collection<Collidable> collidablesToShow) {
        collidablesToShow = collidablesToShow.stream().filter(candidate -> this.collidableVisualizerMap.containsKey(candidate)).collect(Collectors.toSet());
        for (Map.Entry<Collidable, CollidableVisualizer> entry : this.collidableVisualizerMap.entrySet()) {
            if (collidablesToShow.contains(entry.getKey())) {
                entry.getValue().update();
                continue;
            }
            entry.getValue().hide();
        }
    }
}

