/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.partNames;

import us.ihmc.euclid.tuple3D.Vector3D;

public enum LegJointName {
    FUTURE_EXPANSION_TEST1,
    HIP_PITCH,
    HIP_ROLL,
    FUTURE_EXPANSION_TEST2,
    HIP_YAW,
    KNEE_PITCH,
    KNEE_YAW,
    KNEE_ROLL,
    ANKLE_ROLL,
    ANKLE_PITCH,
    FUTURE_EXPANSION_TEST3;

    public static final LegJointName[] values;

    public String getUnderBarName() {
        switch (this) {
            case HIP_YAW: {
                return "hip_yaw";
            }
            case HIP_ROLL: {
                return "hip_roll";
            }
            case HIP_PITCH: {
                return "hip_pitch";
            }
            case KNEE_PITCH: {
                return "knee_pitch";
            }
            case KNEE_YAW: {
                return "knee_yaw";
            }
            case ANKLE_PITCH: {
                return "ankle_pitch";
            }
            case ANKLE_ROLL: {
                return "ankle_roll";
            }
        }
        return "unknown";
    }

    public String getShortUnderBarName() {
        switch (this) {
            case HIP_YAW: {
                return "h_yaw";
            }
            case HIP_ROLL: {
                return "h_roll";
            }
            case HIP_PITCH: {
                return "h_pitch";
            }
            case KNEE_PITCH: {
                return "k_pitch";
            }
            case ANKLE_PITCH: {
                return "a_pitch";
            }
            case ANKLE_ROLL: {
                return "a_roll";
            }
        }
        return "unknown";
    }

    public String getCamelCaseName() {
        switch (this) {
            case HIP_YAW: {
                return "hipYaw";
            }
            case HIP_ROLL: {
                return "hipRoll";
            }
            case HIP_PITCH: {
                return "hipPitch";
            }
            case KNEE_PITCH: {
                return "kneePitch";
            }
            case KNEE_YAW: {
                return "kneeYaw";
            }
            case ANKLE_ROLL: {
                return "ankleRoll";
            }
            case ANKLE_PITCH: {
                return "anklePitch";
            }
        }
        return "unknown Position";
    }

    public String getCamelCaseNameForStartOfExpression() {
        return this.getCamelCaseName();
    }

    public String getPascalCaseName() {
        switch (this) {
            case HIP_YAW: {
                return "HipYaw";
            }
            case HIP_ROLL: {
                return "HipRoll";
            }
            case HIP_PITCH: {
                return "HipPitch";
            }
            case KNEE_PITCH: {
                return "KneePitch";
            }
            case KNEE_YAW: {
                return "KneeYaw";
            }
            case ANKLE_ROLL: {
                return "AnkleRoll";
            }
            case ANKLE_PITCH: {
                return "AnklePitch";
            }
        }
        return "Unknown Position";
    }

    public String getCamelCaseNameForMiddleOfExpression() {
        return this.getPascalCaseName();
    }

    public Vector3D getJointAxis() {
        switch (this) {
            case HIP_YAW: {
                return LegJointName.zAxis();
            }
            case HIP_ROLL: {
                return LegJointName.xAxis();
            }
            case HIP_PITCH: {
                return LegJointName.yAxis();
            }
            case KNEE_PITCH: {
                return LegJointName.yAxis();
            }
            case KNEE_YAW: {
                return LegJointName.zAxis();
            }
            case ANKLE_PITCH: {
                return LegJointName.yAxis();
            }
            case ANKLE_ROLL: {
                return LegJointName.xAxis();
            }
        }
        throw new RuntimeException("Enum constant not handled.");
    }

    public String toString() {
        return this.getPascalCaseName();
    }

    private static Vector3D xAxis() {
        return new Vector3D(1.0, 0.0, 0.0);
    }

    private static Vector3D yAxis() {
        return new Vector3D(0.0, 1.0, 0.0);
    }

    private static Vector3D zAxis() {
        return new Vector3D(0.0, 0.0, 1.0);
    }

    static {
        values = LegJointName.values();
    }
}

