/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.optimization;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class EqualityConstraintEnforcer {
    private final LinearSolverDense<DMatrixRMaj> solver;
    private final DMatrixRMaj q = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj jPlusp = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj x = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj jPlus = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj aCopy = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj j = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj p = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj check = new DMatrixRMaj(1, 1);

    public EqualityConstraintEnforcer(LinearSolverDense<DMatrixRMaj> solver) {
        this.solver = solver;
    }

    public void setConstraint(DMatrixRMaj j, DMatrixRMaj p) {
        this.j.set((DMatrixD1)j);
        this.p.set((DMatrixD1)p);
        if (j.getNumRows() > 0) {
            this.jPlus.reshape(j.getNumCols(), j.getNumRows());
            this.solver.setA((Matrix)j);
            this.solver.invert((Matrix)this.jPlus);
            this.jPlusp.reshape(this.jPlus.getNumRows(), p.getNumCols());
            CommonOps_DDRM.mult((DMatrix1Row)this.jPlus, (DMatrix1Row)p, (DMatrix1Row)this.jPlusp);
            this.q.reshape(this.jPlus.getNumRows(), j.getNumCols());
            CommonOps_DDRM.setIdentity((DMatrix1Row)this.q);
            CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)this.jPlus, (DMatrix1Row)j, (DMatrix1Row)this.q);
        } else {
            this.jPlus.reshape(j.getNumCols(), 0);
            this.q.reshape(j.getNumCols(), j.getNumCols());
            CommonOps_DDRM.setIdentity((DMatrix1Row)this.q);
            this.jPlusp.reshape(j.getNumCols(), 1);
            this.jPlusp.zero();
        }
    }

    public DMatrixRMaj checkJQEqualsZeroAfterSetConstraint() {
        DMatrixRMaj checkJQEqualsZero = new DMatrixRMaj(this.j.getNumRows(), this.q.getNumCols());
        CommonOps_DDRM.mult((DMatrix1Row)this.j, (DMatrix1Row)this.q, (DMatrix1Row)checkJQEqualsZero);
        return checkJQEqualsZero;
    }

    public void constrainEquation(DMatrixRMaj a, DMatrixRMaj b) {
        this.aCopy.set((DMatrixD1)a);
        CommonOps_DDRM.mult((DMatrix1Row)this.aCopy, (DMatrix1Row)this.q, (DMatrix1Row)a);
        CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)this.aCopy, (DMatrix1Row)this.jPlusp, (DMatrix1Row)b);
    }

    public DMatrixRMaj constrainResult(DMatrixRMaj xBar) {
        this.x.reshape(xBar.getNumRows(), 1);
        CommonOps_DDRM.mult((DMatrix1Row)this.q, (DMatrix1Row)xBar, (DMatrix1Row)this.x);
        CommonOps_DDRM.addEquals((DMatrixD1)this.x, (DMatrixD1)this.jPlusp);
        return this.x;
    }

    public DMatrixRMaj getConstraintPseudoInverse() {
        return this.jPlus;
    }

    public boolean areConstraintsEnforcedSuccesfully(DMatrixRMaj x, DMatrixRMaj j, DMatrixRMaj p, double epsilon) {
        if (j.getNumRows() > 0) {
            this.check.reshape(p.getNumRows(), 1);
            CommonOps_DDRM.mult((DMatrix1Row)j, (DMatrix1Row)x, (DMatrix1Row)this.check);
            CommonOps_DDRM.subtractEquals((DMatrixD1)this.check, (DMatrixD1)p);
            return MatrixFeatures_DDRM.isConstantVal((DMatrixRMaj)this.check, (double)0.0, (double)epsilon);
        }
        return true;
    }
}

