/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.optimization;

import java.util.LinkedHashSet;
import java.util.Set;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;

class ActiveSearchSolutionInfo {
    private final DMatrixRMaj solution = new DMatrixRMaj(1, 1);
    private boolean converged;
    private int iterations;
    private final Set<Integer> activeSet = new LinkedHashSet<Integer>();

    ActiveSearchSolutionInfo() {
    }

    public void reset(int solutionSize) {
        this.solution.reshape(solutionSize, 1);
        this.converged = false;
        this.iterations = 0;
        this.activeSet.clear();
    }

    public void setSolution(DMatrixRMaj solution) {
        this.solution.set((DMatrixD1)solution);
    }

    public void clearActiveSet() {
        this.activeSet.clear();
    }

    public DMatrixRMaj getSolution() {
        return this.solution;
    }

    public int getIterations() {
        return this.iterations;
    }

    public Set<Integer> getActiveSet() {
        return this.activeSet;
    }

    public boolean isConverged() {
        return this.converged;
    }

    void setConverged(boolean converged) {
        this.converged = converged;
    }

    public void incrementIterations() {
        ++this.iterations;
    }
}

