/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.numericalMethods;

import java.io.Serializable;

public class QuarticEquationSolver
implements Serializable {
    private static final long serialVersionUID = -256535947296433934L;
    private static final double EQN_EPS = 1.0E-9;
    private static final double ONE_THIRD = 0.3333333333333333;
    private double[] cube_root_t_real = new double[3];
    private double[] cube_root_u_real = new double[3];
    private double[] cube_root_t_imag = new double[3];
    private double[] cube_root_u_imag = new double[3];
    private double[] temp_real = new double[4];
    private double[] temp_imag = new double[4];
    private double[] temp2_real = new double[4];
    private double[] temp2_imag = new double[4];

    public void solveCubicEquation(double p3, double p2, double p1, double p0, double[] solution_real, double[] solution_imag) {
        if (Math.abs(p3) < 1.0E-9) {
            this.solveQuadraticEquation(p2, p1, p0, solution_real, solution_imag);
            solution_real[2] = 0.0;
            solution_imag[2] = 0.0;
        } else {
            this.solveCubicEquation(p2 / p3, p1 / p3, p0 / p3, solution_real, solution_imag);
        }
    }

    public void solveCubicEquation(double A, double B, double C, double[] solution_real, double[] solution_imag) {
        solution_imag[2] = 0.0;
        solution_imag[1] = 0.0;
        solution_imag[0] = 0.0;
        int num_real_solutions = this.solveCubicEquationReal(A, B, C, solution_real);
        if (num_real_solutions > 1) {
            return;
        }
        double y_real = solution_real[0];
        this.solveQuadraticEquation(1.0, A + y_real, A * y_real + y_real * y_real + B, solution_real, solution_imag);
        solution_real[2] = y_real;
    }

    private int solveCubicEquationReal(double A, double B, double C, double[] s) {
        int num;
        double sq_A = A * A;
        double q = 0.5 * (0.07407407407407407 * A * sq_A - 0.3333333333333333 * A * B + C);
        double p = 0.3333333333333333 * (-0.3333333333333333 * sq_A + B);
        double cb_p = p * p * p;
        double D = q * q + cb_p;
        if (Math.abs(D) < 1.0E-9) {
            if (Math.abs(q) < 1.0E-9) {
                s[0] = 0.0;
                num = 1;
            } else {
                double u = this.cbrt(-q);
                s[0] = 2.0 * u;
                s[1] = -u;
                num = 2;
            }
        } else if (D < 0.0) {
            double phi = 0.3333333333333333 * Math.acos(-q / Math.sqrt(-cb_p));
            double t = 2.0 * Math.sqrt(-p);
            s[0] = t * Math.cos(phi);
            s[1] = -t * Math.cos(phi + 1.0471975511965976);
            s[2] = -t * Math.cos(phi - 1.0471975511965976);
            num = 3;
        } else {
            double sqrt_D = Math.sqrt(D);
            double u = this.cbrt(sqrt_D - q);
            double v = -this.cbrt(sqrt_D + q);
            s[0] = u + v;
            num = 1;
        }
        double sub = 0.3333333333333333 * A;
        int i = 0;
        while (i < num) {
            int n = i++;
            s[n] = s[n] - sub;
        }
        return num;
    }

    private double cbrt(double x) {
        if (x >= 0.0) {
            return Math.pow(x, 0.3333333333333333);
        }
        return -Math.pow(-x, 0.3333333333333333);
    }

    private void solveCubicEquation9(double e, double f, double g, double[] solution_real, double[] solution_imag) {
        double p = f - e * e / 3.0;
        double q = -f * e / 3.0 + g + 0.07407407407407407 * e * e * e;
        double kernel = 4.0 * p * p * p + 27.0 * q * q;
        if (kernel < 0.0) {
            kernel = -kernel;
        }
        double t = -q / 2.0 + Math.sqrt(kernel) / (6.0 * Math.sqrt(3.0));
        double u = q / 2.0 + Math.sqrt(kernel) / (6.0 * Math.sqrt(3.0));
        double y1 = t >= 0.0 && u >= 0.0 ? Math.pow(t, 0.3333333333333333) - Math.pow(u, 0.3333333333333333) : (t >= 0.0 && u < 0.0 ? Math.pow(t, 0.3333333333333333) - Math.pow(-u, 0.3333333333333333) : (t < 0.0 && u >= 0.0 ? Math.pow(-t, 0.3333333333333333) - Math.pow(u, 0.3333333333333333) : Math.pow(-t, 0.3333333333333333) - Math.pow(-u, 0.3333333333333333)));
        this.solveQuadraticEquation(1.0, y1, p + y1 * y1, solution_real, solution_imag);
        solution_real[0] = solution_real[0] - e / 3.0;
        solution_real[1] = solution_real[1] - e / 3.0;
        solution_real[2] = y1 - e / 3.0;
        solution_imag[2] = 0.0;
    }

    public void solveCubicEquation2(double e, double f, double g, double[] solution_real, double[] solution_imag) {
        double Q = (e * e - 3.0 * f) / 9.0;
        double Qcubed = Q * Q * Q;
        double R = (2.0 * e * e * e - 9.0 * e * f + 27.0 * g) / 54.0;
        double d = Qcubed - R * R;
        if (d >= 0.0) {
            double theta = Math.acos(R / Math.sqrt(Qcubed));
            double sqrtQ = Math.sqrt(Q);
            solution_real[0] = -2.0 * sqrtQ * Math.cos(theta / 3.0) - e / 3.0;
            solution_real[1] = -2.0 * sqrtQ * Math.cos((theta + Math.PI * 2) / 3.0) - e / 3.0;
            solution_real[2] = -2.0 * sqrtQ * Math.cos((theta + Math.PI * 4) / 3.0) - e / 3.0;
            solution_imag[2] = 0.0;
            solution_imag[1] = 0.0;
            solution_imag[0] = 0.0;
        } else {
            double ee = Math.sqrt(-d) + Math.pow(Math.abs(R), 0.3333333333333333);
            solution_real[0] = ee + Q / ee - e / 3.0;
            if (R > 0.0) {
                solution_real[0] = -solution_real[0];
            }
            solution_imag[0] = 0.0;
        }
    }

    public void solveQuarticEquation(double p4, double p3, double p2, double p1, double p0, double[] solution_real, double[] solution_imag) {
        if (Math.abs(p4) < 1.0E-9) {
            this.solveCubicEquation(p3, p2, p1, p0, solution_real, solution_imag);
            solution_real[3] = 0.0;
            solution_imag[3] = 0.0;
        } else {
            this.solveQuarticEquation(p3 / p4, p2 / p4, p1 / p4, p0 / p4, solution_real, solution_imag);
        }
    }

    public void solveQuarticEquation(double a, double b, double c, double d, double[] solution_real, double[] solution_imag) {
        if (Math.abs(d) < 1.0E-9) {
            this.solveCubicEquation(a, b, c, solution_real, solution_imag);
            solution_real[3] = 0.0;
            solution_imag[3] = 0.0;
            return;
        }
        double e = b - 3.0 * a * a / 8.0;
        double f = c + a * a * a / 8.0 - a * b / 2.0;
        double g = d - 3.0 * a * a * a * a / 256.0 + a * a * b / 16.0 - a * c / 4.0;
        if (Math.abs(g) < 1.0E-9) {
            this.solveCubicEquation(1.0, e, f, solution_real, solution_imag);
            solution_real[0] = solution_real[0] - a / 4.0;
            solution_real[1] = solution_real[1] - a / 4.0;
            solution_real[2] = solution_real[2] - a / 4.0;
            solution_real[3] = 0.0;
            solution_imag[3] = 0.0;
            return;
        }
        if (Math.abs(f) < 1.0E-9) {
            this.solveQuadraticEquation(1.0, e, g, this.temp_real, this.temp_imag);
            this.solveSquareRoot(this.temp_real[0], this.temp_imag[0], solution_real, solution_imag);
            solution_real[2] = solution_real[0];
            solution_real[3] = solution_real[1];
            solution_imag[2] = solution_imag[0];
            solution_imag[3] = solution_imag[1];
            this.solveSquareRoot(this.temp_real[1], this.temp_imag[1], solution_real, solution_imag);
            return;
        }
        this.solveCubicEquation(e / 2.0, (e * e - 4.0 * g) / 16.0, -f * f / 64.0, this.temp_real, this.temp_imag);
        this.solveSquareRoot(this.temp_real[0], this.temp_imag[0], this.temp2_real, this.temp2_imag);
        double p_real = this.temp2_real[0];
        double p_imag = this.temp2_imag[0];
        this.solveSquareRoot(this.temp_real[1], this.temp_imag[1], this.temp2_real, this.temp2_imag);
        double q_real = this.temp2_real[0];
        double q_imag = this.temp2_imag[0];
        double pq_real = p_real * q_real - p_imag * q_imag;
        double pq_imag = p_real * q_imag + p_imag * q_real;
        double a2_b2 = pq_real * pq_real + pq_imag * pq_imag;
        pq_imag = -pq_imag / a2_b2;
        double r_real = -8.0 / f * (pq_real /= a2_b2);
        double r_imag = -8.0 / f * pq_imag;
        solution_real[0] = p_real + q_real + r_real - a / 4.0;
        solution_imag[0] = p_imag + q_imag + r_imag;
        solution_real[1] = p_real - q_real - r_real - a / 4.0;
        solution_imag[1] = p_imag - q_imag - r_imag;
        solution_real[2] = -p_real + q_real - r_real - a / 4.0;
        solution_imag[2] = -p_imag + q_imag - r_imag;
        solution_real[3] = -p_real - q_real + r_real - a / 4.0;
        solution_imag[3] = -p_imag - q_imag + r_imag;
        throw new RuntimeException("This doesn't seem to work. Fix and get the test cases passing...");
    }

    private void solveCubeRoot(double x_real, double x_imag, double[] y_real, double[] y_imag) {
        double r = Math.sqrt(x_real * x_real + x_imag * x_imag);
        double theta = Math.atan2(x_imag, x_real);
        double r2 = Math.pow(r, 0.3333333333333333);
        double theta2_1 = theta / 3.0;
        double theta2_2 = theta / 3.0 + 2.0943951023931953;
        double theta2_3 = theta / 3.0 + 4.1887902047863905;
        y_real[0] = r2 * Math.cos(theta2_1);
        y_imag[0] = r2 * Math.sin(theta2_1);
        y_real[1] = r2 * Math.cos(theta2_2);
        y_imag[1] = r2 * Math.sin(theta2_2);
        y_real[2] = r2 * Math.cos(theta2_3);
        y_imag[2] = r2 * Math.sin(theta2_3);
    }

    private void solveSquareRoot(double x_real, double x_imag, double[] y_real, double[] y_imag) {
        double r = Math.sqrt(x_real * x_real + x_imag * x_imag);
        double theta = Math.atan2(x_imag, x_real);
        double r2 = Math.sqrt(r);
        double theta2_1 = theta / 2.0;
        double theta2_2 = theta / 2.0 + Math.PI;
        y_real[0] = r2 * Math.cos(theta2_1);
        y_imag[0] = r2 * Math.sin(theta2_1);
        y_real[1] = r2 * Math.cos(theta2_2);
        y_imag[1] = r2 * Math.sin(theta2_2);
    }

    public void solveQuadraticEquation(double a, double b, double c, double[] x_real, double[] x_imag) {
        double two_a = 2.0 * a;
        x_imag[1] = 0.0;
        x_imag[0] = 0.0;
        x_real[0] = x_real[1] = -b / two_a;
        double b2_4ac = b * b - 4.0 * a * c;
        if (b2_4ac >= 0.0) {
            double sqrt_b2_4ac = Math.sqrt(b2_4ac);
            x_real[0] = x_real[0] + sqrt_b2_4ac / two_a;
            x_real[1] = x_real[1] - sqrt_b2_4ac / two_a;
            return;
        }
        double sqrt_b2_4ac = Math.sqrt(-b2_4ac);
        x_imag[0] = sqrt_b2_4ac / two_a;
        x_imag[1] = -sqrt_b2_4ac / two_a;
    }
}

