/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.numericalMethods;

public class NewtonRaphsonMethod {
    private double previousX;
    private double previousY;
    private double change = Double.POSITIVE_INFINITY;
    private int iterations = 0;
    private final int maxIterations;
    private final double epsilon;

    public NewtonRaphsonMethod(int maxIterations, double epsilon) {
        this(maxIterations, epsilon, 0.0, Double.NaN);
    }

    public NewtonRaphsonMethod(int maxIterations, double epsilon, double initialX, double initialY) {
        NewtonRaphsonMethod.doChecks(maxIterations, epsilon);
        this.maxIterations = maxIterations;
        this.epsilon = epsilon;
        this.previousX = initialX;
        this.previousY = initialY;
    }

    public void update(double x, double y) {
        double derivative = Double.isNaN(this.previousY) ? this.getRandomDerivative() : (y - this.previousY) / (x - this.previousX);
        this.update(x, y, derivative);
    }

    public void update(double x, double y, double derivative) {
        this.change = -y / derivative;
        this.previousX = x;
        this.previousY = y;
        ++this.iterations;
    }

    public double nextX() {
        return this.previousX + this.change;
    }

    public boolean stop() {
        return this.iterations >= this.maxIterations || Math.abs(this.previousY) < this.epsilon;
    }

    public int getIterations() {
        return this.iterations;
    }

    private double getRandomDerivative() {
        return 1.0E-7;
    }

    private static void doChecks(int maxIterations, double epsilon) {
        if (Double.isNaN(epsilon)) {
            throw new RuntimeException("Double.isNaN(epsilon)");
        }
        if (maxIterations < 0) {
            throw new RuntimeException("maxIterations < 0");
        }
        if (epsilon < 0.0) {
            throw new RuntimeException("epsilon < 0.0");
        }
    }
}

