/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.numericalMethods;

import gnu.trove.list.array.TDoubleArrayList;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.numericalMethods.SingleQueryFunction;

public class GradientDescentModule {
    private static final boolean DEBUG = false;
    private SingleQueryFunction function;
    private final int dimension;
    private final TDoubleArrayList initialInput;
    private boolean solved;
    private TDoubleArrayList optimalInput;
    private double optimalQuery;
    private double computationTime;
    private TDoubleArrayList inputUpperLimit;
    private TDoubleArrayList inputLowerLimit;
    private double deltaThreshold = 1.0E-9;
    private int maximumIterations = 1000;
    private double alpha = -10.0;
    private double perturb = 0.001;
    private int reducingStepSizeRatio = 2;

    public GradientDescentModule(SingleQueryFunction function, TDoubleArrayList initial) {
        this.function = function;
        this.dimension = initial.size();
        this.initialInput = new TDoubleArrayList();
        this.optimalInput = new TDoubleArrayList();
        this.inputUpperLimit = new TDoubleArrayList();
        this.inputLowerLimit = new TDoubleArrayList();
        for (int i = 0; i < this.dimension; ++i) {
            this.initialInput.add(initial.get(i));
            this.optimalInput.add(0.0);
            this.inputUpperLimit.add(Double.POSITIVE_INFINITY);
            this.inputLowerLimit.add(Double.NEGATIVE_INFINITY);
        }
    }

    public void redefineModule(SingleQueryFunction function) {
        this.function = function;
    }

    private void reduceStepSize() {
        this.alpha /= (double)this.reducingStepSizeRatio;
    }

    public void setMaximumIterations(int value) {
        this.maximumIterations = value;
    }

    public void setInputUpperLimit(TDoubleArrayList limit) {
        this.inputUpperLimit.clear();
        for (int i = 0; i < this.dimension; ++i) {
            this.inputUpperLimit.add(limit.get(i));
        }
    }

    public void setInputLowerLimit(TDoubleArrayList limit) {
        this.inputLowerLimit.clear();
        for (int i = 0; i < this.dimension; ++i) {
            this.inputLowerLimit.add(limit.get(i));
        }
    }

    public void setConvergenceThreshold(double value) {
        this.deltaThreshold = value;
    }

    public void setStepSize(double value) {
        this.alpha = value > 0.0 ? -value : value;
    }

    public void setPerturbationSize(double value) {
        this.perturb = value > 0.0 ? value : -value;
    }

    public void setReducingStepSizeRatio(int value) {
        this.reducingStepSizeRatio = value;
    }

    public int run() {
        long startTime = System.nanoTime();
        this.solved = false;
        int iteration = 0;
        TDoubleArrayList pastInput = new TDoubleArrayList();
        for (int i = 0; i < this.dimension; ++i) {
            pastInput.add(this.initialInput.get(i));
        }
        this.optimalQuery = this.function.getQuery(pastInput);
        double pastQuery = 0.0;
        double newQuery = 0.0;
        for (int i = 0; i < this.maximumIterations; ++i) {
            int j;
            long curTime = System.nanoTime();
            ++iteration;
            pastQuery = this.optimalQuery;
            double tempSignForPerturb = 1.0;
            TDoubleArrayList gradient = new TDoubleArrayList();
            for (j = 0; j < this.dimension; ++j) {
                TDoubleArrayList perturbedInput = new TDoubleArrayList();
                for (int k = 0; k < this.dimension; ++k) {
                    perturbedInput.add(pastInput.get(k));
                }
                if (perturbedInput.get(j) == this.inputUpperLimit.get(j)) {
                    tempSignForPerturb = -1.0;
                }
                double tempInput = perturbedInput.get(j) + this.perturb * tempSignForPerturb;
                perturbedInput.replace(j, MathTools.clamp((double)tempInput, (double)this.inputLowerLimit.get(j), (double)this.inputUpperLimit.get(j)));
                double perturbedQuery = this.function.getQuery(perturbedInput);
                gradient.add((perturbedQuery - pastQuery) / (this.perturb * tempSignForPerturb));
            }
            this.optimalInput.clear();
            for (j = 0; j < this.dimension; ++j) {
                double input = pastInput.get(j) + gradient.get(j) * this.alpha;
                this.optimalInput.add(MathTools.clamp((double)input, (double)this.inputLowerLimit.get(j), (double)this.inputUpperLimit.get(j)));
            }
            newQuery = this.function.getQuery(this.optimalInput);
            if (newQuery > pastQuery) {
                this.reduceStepSize();
                this.optimalInput.clear();
                for (j = 0; j < this.dimension; ++j) {
                    this.optimalInput.add(pastInput.get(j));
                }
            } else {
                this.optimalQuery = newQuery;
                double delta = Math.abs((pastQuery - this.optimalQuery) / this.optimalQuery);
                if (delta < this.deltaThreshold) break;
            }
            pastInput.clear();
            for (j = 0; j < this.dimension; ++j) {
                pastInput.add(this.optimalInput.get(j));
            }
        }
        this.computationTime = Conversions.nanosecondsToSeconds((long)(System.nanoTime() - startTime));
        return iteration;
    }

    public boolean isSolved() {
        return this.solved;
    }

    public TDoubleArrayList getOptimalInput() {
        return this.optimalInput;
    }

    public double getOptimalQuery() {
        return this.optimalQuery;
    }

    public double getComputationTime() {
        return this.computationTime;
    }
}

