/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.yoVariables;

import org.apache.commons.lang3.ArrayUtils;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolynomial3D;
import us.ihmc.robotics.math.trajectories.core.PolynomialTools;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialBasics;
import us.ihmc.robotics.time.TimeInterval;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoPolynomial
implements YoGraphicPolynomial3D.PolynomialVariableHolder,
PolynomialBasics {
    private final int maximumNumberOfCoefficients;
    private double pos;
    private double vel;
    private double acc;
    private double jerk;
    private double dPos;
    private final YoDouble[] a;
    private final double[] coefficientsCopy;
    private final YoDouble currentTime;
    private final YoInteger numberOfCoefficients;
    private final DMatrixRMaj constraintMatrix;
    private final DMatrixRMaj constraintVector;
    private final DMatrixRMaj coefficientVector;
    private final double[] xPowers;
    private final TimeIntervalBasics timeInterval = new TimeInterval();
    private boolean isConstraintMatrixUpToDate = false;
    private final DMatrixRMaj xPowersDerivativeVector;
    private final LinearSolverDense<DMatrixRMaj> solver;

    public YoPolynomial(String name, int maximumNumberOfCoefficients, YoRegistry registry) {
        this(YoPolynomial.createCoefficientsArray(name, maximumNumberOfCoefficients, registry), new YoInteger(name + "_nCoeffs", registry), new YoDouble(name + "_tCurrent", registry));
    }

    public YoPolynomial(YoDouble[] coefficients, YoInteger numberOfCoefficients, YoDouble currentTime) {
        this.a = coefficients;
        this.numberOfCoefficients = numberOfCoefficients;
        this.currentTime = currentTime;
        this.maximumNumberOfCoefficients = coefficients.length;
        this.coefficientsCopy = new double[this.maximumNumberOfCoefficients];
        this.solver = LinearSolverFactory_DDRM.general((int)this.maximumNumberOfCoefficients, (int)this.maximumNumberOfCoefficients);
        this.constraintMatrix = new DMatrixRMaj(this.maximumNumberOfCoefficients, this.maximumNumberOfCoefficients);
        this.constraintVector = new DMatrixRMaj(this.maximumNumberOfCoefficients, 1);
        this.coefficientVector = new DMatrixRMaj(this.maximumNumberOfCoefficients, 1);
        this.xPowers = new double[this.maximumNumberOfCoefficients];
        this.xPowersDerivativeVector = new DMatrixRMaj(this.maximumNumberOfCoefficients, 1);
    }

    private static YoDouble[] createCoefficientsArray(String name, int maximumNumberOfCoefficients, YoRegistry registry) {
        if (maximumNumberOfCoefficients < 1) {
            throw new IllegalArgumentException("You have to make the polynomial to have at least 1 coefficient!");
        }
        YoDouble[] a = new YoDouble[maximumNumberOfCoefficients];
        for (int i = 0; i < maximumNumberOfCoefficients; ++i) {
            a[i] = new YoDouble(name + "_a" + i, registry);
        }
        return a;
    }

    public double getValue() {
        return this.pos;
    }

    @Override
    public double getVelocity() {
        return this.vel;
    }

    @Override
    public double getAcceleration() {
        return this.acc;
    }

    @Override
    public double getCoefficient(int i) {
        return this.a[i].getDoubleValue();
    }

    @Override
    public void setNumberOfCoefficients(int numberOfCoefficients) {
        this.numberOfCoefficients.set(numberOfCoefficients);
    }

    public double getJerk() {
        return this.jerk;
    }

    @Override
    public double[] getCoefficients() {
        this.setCoefficientsCopy();
        return this.coefficientsCopy;
    }

    @Override
    public double getCurrentTime() {
        return this.currentTime.getDoubleValue();
    }

    @Override
    public void setCurrentTime(double currentTime) {
        this.currentTime.set(currentTime);
    }

    private void setCoefficientsCopy() {
        int row;
        for (row = 0; row < this.getNumberOfCoefficients(); ++row) {
            this.coefficientsCopy[row] = this.a[row].getDoubleValue();
        }
        while (row < this.maximumNumberOfCoefficients) {
            this.coefficientsCopy[row] = Double.NaN;
            ++row;
        }
    }

    @Override
    public DMatrixRMaj getCoefficientsVector() {
        return this.coefficientVector;
    }

    public YoDouble[] getYoCoefficients() {
        return this.a;
    }

    @Override
    public void solveForCoefficients() {
        this.solver.setA((Matrix)this.constraintMatrix);
        this.solver.solve((Matrix)this.constraintVector, (Matrix)this.coefficientVector);
    }

    @Override
    public void setIsConstraintMatrixUpToDate(boolean isConstraintMatrixUpToDate) {
        this.isConstraintMatrixUpToDate = isConstraintMatrixUpToDate;
    }

    @Override
    public boolean isConstraintMatrixUpToDate() {
        return this.isConstraintMatrixUpToDate;
    }

    public void setDirectly(int power, double coefficient) {
        this.setIsConstraintMatrixUpToDate(false);
        if (power >= this.maximumNumberOfCoefficients) {
            throw new RuntimeException("Maximum number of coefficients is: " + this.maximumNumberOfCoefficients + ", can't set coefficient as it requires: " + power + 1 + " coefficients");
        }
        if (power >= this.getNumberOfCoefficients()) {
            for (int i = this.getNumberOfCoefficients(); i <= power; ++i) {
                this.a[i].set(0.0);
            }
            this.coefficientVector.reshape(power + 1, 1);
            this.constraintMatrix.reshape(power + 1, power + 1);
            this.constraintVector.reshape(power + 1, 1);
            this.xPowersDerivativeVector.reshape(power + 1, 1);
            this.numberOfCoefficients.set(power + 1);
        }
        this.a[power].set(coefficient);
    }

    public void setDirectlyReverse(double[] coefficients) {
        ArrayUtils.reverse((double[])coefficients);
        this.setDirectly(coefficients);
    }

    @Override
    public void compute(double x) {
        int i;
        this.setCurrentTime(x);
        PolynomialTools.setXPowers(this.xPowers, x);
        this.jerk = 0.0;
        this.acc = 0.0;
        this.vel = 0.0;
        this.pos = 0.0;
        for (i = 0; i < this.numberOfCoefficients.getIntegerValue(); ++i) {
            this.pos += this.a[i].getDoubleValue() * this.xPowers[i];
        }
        for (i = 1; i < this.numberOfCoefficients.getIntegerValue(); ++i) {
            this.vel += (double)i * this.a[i].getDoubleValue() * this.xPowers[i - 1];
        }
        for (i = 2; i < this.numberOfCoefficients.getIntegerValue(); ++i) {
            this.acc += (double)((i - 1) * i) * this.a[i].getDoubleValue() * this.xPowers[i - 2];
        }
        for (i = 3; i < this.numberOfCoefficients.getIntegerValue(); ++i) {
            this.jerk += (double)((i - 2) * (i - 1) * i) * this.a[i].getDoubleValue() * this.xPowers[i - 3];
        }
    }

    @Override
    public int getNumberOfCoefficients() {
        return this.numberOfCoefficients.getIntegerValue();
    }

    public YoInteger getYoNumberOfCoefficients() {
        return this.numberOfCoefficients;
    }

    @Override
    public int getMaximumNumberOfCoefficients() {
        return this.maximumNumberOfCoefficients;
    }

    @Override
    public void setConstraintRow(int row, double x, double desiredZDerivative, int derivativeOrderWithPositionBeingZero) {
        double xPower = 1.0;
        for (int col = derivativeOrderWithPositionBeingZero; col < this.getNumberOfCoefficients(); ++col) {
            double columnPower = 1.0;
            for (int i = 0; i < derivativeOrderWithPositionBeingZero; ++i) {
                columnPower *= (double)(col - i);
            }
            this.constraintMatrix.set(row, col, xPower * columnPower);
            xPower *= x;
        }
        this.constraintVector.set(row, 0, desiredZDerivative);
    }

    @Override
    public void reshape(int numberOfCoefficientsRequired) {
        if (numberOfCoefficientsRequired > this.maximumNumberOfCoefficients) {
            throw new RuntimeException("Maximum number of coefficients is: " + this.maximumNumberOfCoefficients + ", can't build the polynomial as it requires: " + numberOfCoefficientsRequired + " coefficients.");
        }
        this.coefficientVector.reshape(numberOfCoefficientsRequired, 1);
        this.constraintMatrix.reshape(numberOfCoefficientsRequired, numberOfCoefficientsRequired);
        this.constraintVector.reshape(numberOfCoefficientsRequired, 1);
        this.xPowersDerivativeVector.reshape(numberOfCoefficientsRequired, 1);
        this.numberOfCoefficients.set(numberOfCoefficientsRequired);
        this.constraintMatrix.zero();
        this.constraintVector.zero();
        this.coefficientVector.zero();
        for (int i = numberOfCoefficientsRequired; i < this.maximumNumberOfCoefficients; ++i) {
            this.a[i].set(Double.NaN);
        }
    }

    @Override
    public void setCoefficientUnsafe(int idx, double value) {
        this.a[idx].set(value);
    }

    public String toString() {
        String inString = "Polynomial: " + this.a[0].getDoubleValue();
        for (int i = 1; i < this.getNumberOfCoefficients(); ++i) {
            inString = inString + " ";
            if (this.a[i].getDoubleValue() >= 0.0) {
                inString = inString + "+";
            }
            inString = inString + this.a[i].getDoubleValue() + " x^" + i;
        }
        return inString;
    }

    @Override
    public TimeIntervalBasics getTimeInterval() {
        return this.timeInterval;
    }
}

