/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.yoVariables;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoParabolicTrajectoryGenerator {
    private final String nameSuffix = this.getClass().getSimpleName();
    private final YoRegistry registry;
    private final ReferenceFrame referenceFrame;
    private final YoFrameVector3D c0;
    private final YoFrameVector3D c1;
    private final YoFrameVector3D c2;
    private final FrameVector3D tempInitialize;
    private final FramePoint3D tempPackPosition;

    public YoParabolicTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.nameSuffix);
        this.referenceFrame = referenceFrame;
        this.c0 = new YoFrameVector3D("c0", "", referenceFrame, this.registry);
        this.c1 = new YoFrameVector3D("c1", "", referenceFrame, this.registry);
        this.c2 = new YoFrameVector3D("c2", "", referenceFrame, this.registry);
        this.tempInitialize = new FrameVector3D(referenceFrame);
        this.tempPackPosition = new FramePoint3D(referenceFrame);
        parentRegistry.addChild(this.registry);
    }

    public void initialize(FramePoint3DReadOnly initialPosition, FramePoint3DReadOnly finalPosition, double heightAtParameter, double parameter) {
        double q = parameter;
        MathTools.checkIntervalContains((double)q, (double)0.0, (double)1.0);
        FramePoint3D tempInitialPosition = new FramePoint3D((FrameTuple3DReadOnly)initialPosition);
        FramePoint3D tempFinalPosition = new FramePoint3D((FrameTuple3DReadOnly)finalPosition);
        tempInitialPosition.changeFrame(this.referenceFrame);
        tempFinalPosition.changeFrame(this.referenceFrame);
        FramePoint3D intermediatePosition = new FramePoint3D(this.referenceFrame);
        intermediatePosition.setX(tempInitialPosition.getX() + q * (tempFinalPosition.getX() - tempInitialPosition.getX()));
        intermediatePosition.setY(tempInitialPosition.getY() + q * (tempFinalPosition.getY() - tempInitialPosition.getY()));
        intermediatePosition.setZ(heightAtParameter);
        this.initialize(tempInitialPosition, intermediatePosition, tempFinalPosition, q);
    }

    public void initialize(FramePoint3D initialPosition, FramePoint3D intermediatePosition, FramePoint3D finalPosition, double intermediateParameter) {
        initialPosition.changeFrame(this.referenceFrame);
        intermediatePosition.changeFrame(this.referenceFrame);
        finalPosition.changeFrame(this.referenceFrame);
        double q = intermediateParameter;
        MathTools.checkIntervalContains((double)q, (double)0.0, (double)1.0);
        this.c0.set((FrameTuple3DReadOnly)initialPosition);
        this.c2.set((FrameTuple3DReadOnly)intermediatePosition);
        this.c2.sub((FrameTuple3DReadOnly)initialPosition);
        this.tempInitialize.set((FrameTuple3DReadOnly)finalPosition);
        this.tempInitialize.sub((FrameTuple3DReadOnly)initialPosition);
        this.tempInitialize.scale(q);
        this.c2.sub((FrameTuple3DReadOnly)this.tempInitialize);
        this.c2.scale(1.0 / (MathTools.square((double)q) - q));
        this.c1.set((FrameTuple3DReadOnly)finalPosition);
        this.c1.sub((FrameTuple3DReadOnly)initialPosition);
        this.c1.sub((FrameTuple3DReadOnly)this.c2);
    }

    public void initialize(FramePoint3D initialPosition, FrameVector3D initialVelocity, FramePoint3D finalPosition) {
        initialPosition.changeFrame(this.referenceFrame);
        initialVelocity.changeFrame(this.referenceFrame);
        finalPosition.changeFrame(this.referenceFrame);
        this.c0.set((FrameTuple3DReadOnly)initialPosition);
        this.c1.set((FrameTuple3DReadOnly)initialVelocity);
        this.c2.set((FrameTuple3DReadOnly)finalPosition);
        this.c2.sub((FrameTuple3DReadOnly)initialPosition);
        this.c2.sub((FrameTuple3DReadOnly)initialVelocity);
    }

    public void getPosition(FramePoint3D positionToPack, double parameter) {
        double q = parameter;
        MathTools.checkIntervalContains((double)q, (double)0.0, (double)1.0);
        positionToPack.setToZero(this.referenceFrame);
        positionToPack.set((FrameTuple3DReadOnly)this.c2);
        positionToPack.scale(MathTools.square((double)q));
        this.tempPackPosition.set((FrameTuple3DReadOnly)this.c1);
        this.tempPackPosition.scale(q);
        positionToPack.add((FrameTuple3DReadOnly)this.tempPackPosition);
        positionToPack.add((FrameTuple3DReadOnly)this.c0);
    }

    public void getVelocity(FrameVector3D velocityToPack, double parameter) {
        double q = parameter;
        MathTools.checkIntervalContains((double)q, (double)0.0, (double)1.0);
        velocityToPack.setToZero(this.referenceFrame);
        velocityToPack.set((FrameTuple3DReadOnly)this.c2);
        velocityToPack.scale(2.0 * q);
        velocityToPack.add((FrameTuple3DReadOnly)this.c1);
    }

    public void getAcceleration(FrameVector3D accelerationToPack) {
        accelerationToPack.setToZero(this.referenceFrame);
        accelerationToPack.set((FrameTuple3DReadOnly)this.c2);
        accelerationToPack.scale(2.0);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }
}

