/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.yoVariables;

import gnu.trove.list.array.TDoubleArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.PointCloud3DMeshGenerator;
import us.ihmc.graphicsDescription.SegmentedLine3DMeshDataGenerator;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicJob;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicTrajectory3D
extends YoGraphic
implements RemoteYoGraphic,
GraphicsUpdatable {
    private static final int COLOR_RESOLUTION = 128;
    private static final AppearanceDefinition BLACK_APPEARANCE = YoAppearance.Black();
    private final YoGraphicJob yoGraphicJob;
    private final double radius;
    private final int resolution;
    private final int radialResolution;
    private final Graphics3DObject graphics3dObject = new Graphics3DObject();
    private final AppearanceDefinition[] colorPalette = YoGraphicTrajectory3D.createColorPalette(128);
    private final SegmentedLine3DMeshDataGenerator segmentedLine3DMeshGenerator;
    private final PointCloud3DMeshGenerator pointCloud3DMeshGenerator;
    private final Graphics3DAddMeshDataInstruction[] graphics3DAddMeshDataInstructions;
    private final FramePoint3D[] intermediatePositions;
    private final FrameVector3D[] intermediateVelocities;
    private final FrameVector3D[] intermediateAccelerations;
    private final boolean hasPoseDefined;
    private final YoFramePose3D poseToWorldFrame;
    private final FixedFramePositionTrajectoryGenerator trajectoryGenerator;
    private final DoubleProvider trajectoryDuration;
    private final YoEnum<?> currentGraphicType;
    private final YoEnum<?> currentColorType;
    private final YoBoolean readerExists;
    private final AtomicBoolean dirtyGraphic = new AtomicBoolean(false);
    private final RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();

    public YoGraphicTrajectory3D(String name, FixedFramePositionTrajectoryGenerator trajectoryGenerator, YoDouble trajectoryDuration, double radius, int resolution, int radialResolution, YoRegistry registry) {
        this(name, null, trajectoryGenerator, (DoubleProvider)trajectoryDuration, radius, resolution, radialResolution, registry);
    }

    public YoGraphicTrajectory3D(String name, YoFramePose3D poseFromTrajectoryFrameToWorldFrame, FixedFramePositionTrajectoryGenerator trajectoryGenerator, DoubleProvider trajectoryDuration, double radius, int resolution, int radialResolution, YoRegistry registry) {
        super(name);
        int i;
        this.trajectoryGenerator = trajectoryGenerator;
        this.trajectoryDuration = trajectoryDuration;
        this.yoGraphicJob = YoGraphicJob.WRITER;
        this.radius = radius;
        this.resolution = resolution;
        this.radialResolution = radialResolution;
        this.hasPoseDefined = poseFromTrajectoryFrameToWorldFrame != null;
        this.poseToWorldFrame = poseFromTrajectoryFrameToWorldFrame;
        this.currentGraphicType = new YoEnum(name + "CurrentGraphicType", registry, TrajectoryGraphicType.class, false);
        this.currentColorType = new YoEnum(name + "CurrentColorType", registry, TrajectoryColorType.class, false);
        this.readerExists = new YoBoolean(name + "ReaderExists", registry);
        this.intermediatePositions = new FramePoint3D[resolution];
        this.intermediateVelocities = new FrameVector3D[resolution];
        this.intermediateAccelerations = new FrameVector3D[resolution];
        for (i = 0; i < resolution; ++i) {
            this.intermediatePositions[i] = new FramePoint3D();
            this.intermediateVelocities[i] = new FrameVector3D();
            this.intermediateAccelerations[i] = new FrameVector3D();
        }
        this.segmentedLine3DMeshGenerator = new SegmentedLine3DMeshDataGenerator(resolution, radialResolution, radius);
        this.pointCloud3DMeshGenerator = new PointCloud3DMeshGenerator(resolution, radialResolution, radius);
        this.graphics3DAddMeshDataInstructions = new Graphics3DAddMeshDataInstruction[resolution - 1];
        this.graphics3dObject.setChangeable(true);
        for (i = 0; i < resolution - 1; ++i) {
            this.graphics3DAddMeshDataInstructions[i] = this.graphics3dObject.addMeshData(this.segmentedLine3DMeshGenerator.getMeshDataHolders()[i], YoAppearance.AliceBlue());
        }
        this.setupDirtyGraphicListener();
    }

    private void setupDirtyGraphicListener() {
        this.getVariablesDefiningGraphic().forEach(variable -> variable.addListener(v -> this.dirtyGraphic.set(true)));
    }

    public void setColorType(TrajectoryColorType colorType) {
        this.setCurrentColorType(colorType);
    }

    public void showGraphic() {
        this.setGraphicType(TrajectoryGraphicType.SHOW_AS_LINE);
    }

    public void hideGraphic() {
        this.setGraphicType(TrajectoryGraphicType.HIDE);
    }

    public void setGraphicType(TrajectoryGraphicType graphicType) {
        this.setCurrentGraphicType(graphicType);
        if (graphicType != TrajectoryGraphicType.HIDE) {
            this.dirtyGraphic.set(true);
            this.update();
        }
    }

    public void update() {
        if (this.yoGraphicJob == YoGraphicJob.READER) {
            this.readerExists.set(true);
        }
        switch (this.yoGraphicJob) {
            case READER: {
                this.computeTrajectoryMesh();
                break;
            }
            case WRITER: {
                if (this.readerExists.getBooleanValue()) break;
                this.computeTrajectoryMesh();
            }
        }
    }

    private void computeTrajectoryMesh() {
        int i;
        if (!this.dirtyGraphic.get()) {
            return;
        }
        if (this.getCurrentGraphicType() == TrajectoryGraphicType.HIDE) {
            for (Graphics3DAddMeshDataInstruction graphics3DAddMeshDataInstruction : this.graphics3DAddMeshDataInstructions) {
                graphics3DAddMeshDataInstruction.setMesh(null);
            }
            this.dirtyGraphic.set(false);
            return;
        }
        for (FramePoint3D framePoint3D : this.intermediatePositions) {
            framePoint3D.setToZero();
        }
        for (FramePoint3D framePoint3D : this.intermediateVelocities) {
            framePoint3D.setToZero();
        }
        for (FramePoint3D framePoint3D : this.intermediateAccelerations) {
            framePoint3D.setToZero();
        }
        double maxVelocity = 0.0;
        double maxAcceleration = 0.0;
        for (i = 0; i < this.resolution; ++i) {
            double t = (double)i / ((double)this.resolution - 1.0) * this.trajectoryDuration.getValue();
            this.trajectoryGenerator.compute(t);
            this.intermediatePositions[i].setIncludingFrame((FrameTuple3DReadOnly)this.trajectoryGenerator.getPosition());
            this.intermediateVelocities[i].setIncludingFrame((FrameTuple3DReadOnly)this.trajectoryGenerator.getVelocity());
            this.intermediateAccelerations[i].setIncludingFrame((FrameTuple3DReadOnly)this.trajectoryGenerator.getAcceleration());
            maxVelocity = Math.max(maxVelocity, this.intermediateVelocities[i].lengthSquared());
            maxAcceleration = Math.max(maxAcceleration, this.intermediateAccelerations[i].lengthSquared());
        }
        maxVelocity = Math.sqrt(maxVelocity);
        maxAcceleration = Math.sqrt(maxAcceleration);
        switch (this.getCurrentColorType()) {
            case BLACK: {
                for (Graphics3DAddMeshDataInstruction meshDataInstruction : this.graphics3DAddMeshDataInstructions) {
                    meshDataInstruction.setAppearance(BLACK_APPEARANCE);
                }
                break;
            }
            case VELOCITY_BASED: {
                for (i = 0; i < this.resolution - 1; ++i) {
                    double velocity = this.intermediateVelocities[i].length();
                    int colorIndex = (int)Math.round(((double)this.colorPalette.length - 1.0) * (velocity / maxVelocity));
                    this.graphics3DAddMeshDataInstructions[i].setAppearance(this.colorPalette[colorIndex]);
                }
                break;
            }
            case ACCELERATION_BASED: {
                for (i = 0; i < this.resolution - 1; ++i) {
                    double acceleration = this.intermediateAccelerations[i].length();
                    int colorIndex = (int)Math.round(((double)this.colorPalette.length - 1.0) * (acceleration / maxAcceleration));
                    this.graphics3DAddMeshDataInstructions[i].setAppearance(this.colorPalette[colorIndex]);
                }
                break;
            }
        }
        switch (this.getCurrentGraphicType()) {
            case SHOW_AS_LINE: {
                if (this.globalScaleProvider != null) {
                    this.segmentedLine3DMeshGenerator.setLineRadius(this.radius * this.globalScaleProvider.getValue());
                }
                this.segmentedLine3DMeshGenerator.compute((Point3DReadOnly[])this.intermediatePositions, (Vector3DReadOnly[])this.intermediateVelocities);
                for (i = 0; i < this.resolution - 1; ++i) {
                    this.graphics3DAddMeshDataInstructions[i].setMesh(this.segmentedLine3DMeshGenerator.getMeshDataHolders()[i]);
                }
                break;
            }
            case SHOW_AS_POINTS: {
                if (this.globalScaleProvider != null) {
                    this.pointCloud3DMeshGenerator.setPointRadius(this.radius * this.globalScaleProvider.getValue());
                }
                this.pointCloud3DMeshGenerator.compute((Point3DReadOnly[])this.intermediatePositions);
                for (i = 0; i < this.resolution - 1; ++i) {
                    this.graphics3DAddMeshDataInstructions[i].setMesh(this.pointCloud3DMeshGenerator.getMeshDataHolders()[i]);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected state: " + (Object)((Object)this.getCurrentGraphicType()));
            }
        }
        this.dirtyGraphic.set(false);
    }

    private void setCurrentGraphicType(TrajectoryGraphicType graphicType) {
        this.currentGraphicType.set(graphicType.ordinal());
    }

    private TrajectoryGraphicType getCurrentGraphicType() {
        return TrajectoryGraphicType.values[this.currentGraphicType.getOrdinal()];
    }

    private void setCurrentColorType(TrajectoryColorType colorType) {
        this.currentColorType.set(colorType.ordinal());
    }

    private TrajectoryColorType getCurrentColorType() {
        return TrajectoryColorType.values[this.currentColorType.getOrdinal()];
    }

    public YoVariable[] getVariables() {
        ArrayList<Object> allVariables = new ArrayList<Object>();
        allVariables.addAll(this.getVariablesDefiningGraphic());
        allVariables.add(this.readerExists);
        return allVariables.toArray(new YoVariable[0]);
    }

    private List<YoVariable> getVariablesDefiningGraphic() {
        ArrayList<YoVariable> graphicVariables = new ArrayList<YoVariable>();
        if (this.poseToWorldFrame != null) {
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoX());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoY());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoZ());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoQx());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoQy());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoQz());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoQs());
        }
        graphicVariables.add((YoVariable)this.currentGraphicType);
        graphicVariables.add((YoVariable)this.currentColorType);
        return graphicVariables;
    }

    public double[] getConstants() {
        TDoubleArrayList allConstants = new TDoubleArrayList();
        allConstants.add(this.radius);
        allConstants.add((double)this.resolution);
        allConstants.add((double)this.radialResolution);
        allConstants.add(this.hasPoseDefined ? 1.0 : 0.0);
        return allConstants.toArray();
    }

    public AppearanceDefinition getAppearance() {
        return YoAppearance.AliceBlue();
    }

    public Graphics3DObject getLinkGraphics() {
        return this.graphics3dObject;
    }

    protected void computeRotationTranslation(AffineTransform transform) {
        if (this.getCurrentGraphicType() == TrajectoryGraphicType.HIDE) {
            return;
        }
        if (this.poseToWorldFrame != null) {
            this.poseToWorldFrame.get((RigidBodyTransformBasics)this.rigidBodyTransform);
            transform.set((RigidBodyTransformReadOnly)this.rigidBodyTransform);
        } else {
            transform.setIdentity();
        }
        this.update();
    }

    protected boolean containsNaN() {
        return this.getCurrentGraphicType() == TrajectoryGraphicType.HIDE;
    }

    public YoGraphicTrajectory3D duplicate(YoRegistry newRegistry) {
        return null;
    }

    public Artifact createArtifact() {
        throw new RuntimeException("Implement Me!");
    }

    private static AppearanceDefinition[] createColorPalette(int size) {
        AppearanceDefinition[] colorPalette = new AppearanceDefinition[size];
        for (int i = 0; i < size; ++i) {
            float hue = 240.0f * (1.0f - (float)i / ((float)size - 1.0f)) / 360.0f;
            colorPalette[i] = YoAppearance.Color((Color)Color.getHSBColor(hue, 0.9f, 0.9f));
        }
        return colorPalette;
    }

    public static enum TrajectoryColorType {
        BLACK,
        VELOCITY_BASED,
        ACCELERATION_BASED;

        public static TrajectoryColorType[] values;

        static {
            values = TrajectoryColorType.values();
        }
    }

    public static enum TrajectoryGraphicType {
        HIDE,
        SHOW_AS_LINE,
        SHOW_AS_POINTS;

        public static TrajectoryGraphicType[] values;

        static {
            values = TrajectoryGraphicType.values();
        }
    }
}

