/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.tools;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSE3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SE3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointBasics;

public class WaypointToStringTools {
    static final NumberFormat format = new DecimalFormat(" 0.000;-0.000");
    static final NumberFormat timeFormat = new DecimalFormat(" 0.00;-0.00");

    public static String waypointToString(FrameEuclideanWaypointBasics frameEuclideanWaypoint) {
        FramePoint3DReadOnly position = frameEuclideanWaypoint.getPosition();
        FrameVector3DReadOnly linearVelocity = frameEuclideanWaypoint.getLinearVelocity();
        ReferenceFrame referenceFrame = frameEuclideanWaypoint.getReferenceFrame();
        return WaypointToStringTools.waypointToString((Point3DReadOnly)position, (Vector3DReadOnly)linearVelocity, referenceFrame, format);
    }

    public static String waypointToString(FrameSO3WaypointBasics frameSO3Waypoint) {
        FrameQuaternionReadOnly orientation = frameSO3Waypoint.getOrientation();
        FrameVector3DReadOnly angularVelocity = frameSO3Waypoint.getAngularVelocity();
        ReferenceFrame referenceFrame = frameSO3Waypoint.getReferenceFrame();
        return WaypointToStringTools.waypointToString((QuaternionReadOnly)orientation, (Vector3DReadOnly)angularVelocity, referenceFrame, format);
    }

    public static String waypointToString(FrameSE3WaypointBasics frameSE3Waypoint) {
        FramePoint3DReadOnly position = frameSE3Waypoint.getPosition();
        FrameQuaternionReadOnly orientation = frameSE3Waypoint.getOrientation();
        FrameVector3DReadOnly linearVelocity = frameSE3Waypoint.getLinearVelocity();
        FrameVector3DReadOnly angularVelocity = frameSE3Waypoint.getAngularVelocity();
        ReferenceFrame referenceFrame = frameSE3Waypoint.getReferenceFrame();
        return WaypointToStringTools.waypointToString((Point3DReadOnly)position, (QuaternionReadOnly)orientation, (Vector3DReadOnly)linearVelocity, (Vector3DReadOnly)angularVelocity, referenceFrame, format);
    }

    public static String waypointToString(EuclideanWaypointBasics simpleEuclideanWaypoint) {
        Point3DReadOnly position = simpleEuclideanWaypoint.getPosition();
        Vector3DReadOnly linearVelocity = simpleEuclideanWaypoint.getLinearVelocity();
        return WaypointToStringTools.waypointToString(position, linearVelocity, format);
    }

    public static String waypointToString(SO3WaypointBasics simpleSO3Waypoint) {
        QuaternionReadOnly orientation = simpleSO3Waypoint.getOrientation();
        Vector3DReadOnly angularVelocity = simpleSO3Waypoint.getAngularVelocity();
        return WaypointToStringTools.waypointToString(orientation, angularVelocity, format);
    }

    public static String waypointToString(SE3WaypointBasics simpleSE3Waypoint) {
        Point3DReadOnly position = simpleSE3Waypoint.getPosition();
        QuaternionReadOnly orientation = simpleSE3Waypoint.getOrientation();
        Vector3DReadOnly linearVelocity = simpleSE3Waypoint.getLinearVelocity();
        Vector3DReadOnly angularVelocity = simpleSE3Waypoint.getAngularVelocity();
        return WaypointToStringTools.waypointToString(position, orientation, linearVelocity, angularVelocity, format);
    }

    public static String waypointToString(Point3DReadOnly position, Vector3DReadOnly linearVelocity, NumberFormat format) {
        return WaypointToStringTools.waypointToString(position, linearVelocity, null, format);
    }

    public static String waypointToString(Point3DReadOnly position, Vector3DReadOnly linearVelocity, ReferenceFrame referenceFrame, NumberFormat format) {
        String referenceFrameToString = referenceFrame == null ? "" : ", " + referenceFrame.getName();
        return "Euclidean waypoint: [" + WaypointToStringTools.positionToString(position, format) + ", " + WaypointToStringTools.linearVelocityToString(linearVelocity, format) + referenceFrameToString + "]";
    }

    public static String waypointToString(QuaternionReadOnly orientation, Vector3DReadOnly angularVelocity, NumberFormat format) {
        return WaypointToStringTools.waypointToString(orientation, angularVelocity, null, format);
    }

    public static String waypointToString(QuaternionReadOnly orientation, Vector3DReadOnly angularVelocity, ReferenceFrame referenceFrame, NumberFormat format) {
        String referenceFrameToString = referenceFrame == null ? "" : ", " + referenceFrame.getName();
        return "SO3 waypoint: [" + WaypointToStringTools.orientationToString(orientation, format) + ", " + WaypointToStringTools.angularVelocityToString(angularVelocity, format) + referenceFrameToString + "]";
    }

    public static String waypointToString(Point3DReadOnly position, QuaternionReadOnly orientation, Vector3DReadOnly linearVelocity, Vector3DReadOnly angularVelocity, NumberFormat format) {
        return WaypointToStringTools.waypointToString(position, orientation, linearVelocity, angularVelocity, null, format);
    }

    public static String waypointToString(Point3DReadOnly position, QuaternionReadOnly orientation, Vector3DReadOnly linearVelocity, Vector3DReadOnly angularVelocity, ReferenceFrame referenceFrame, NumberFormat format) {
        String referenceFrameToString = referenceFrame == null ? "" : ", " + referenceFrame.getName();
        return "SE3 waypoint: [" + WaypointToStringTools.positionToString(position, format) + ", " + WaypointToStringTools.orientationToString(orientation, format) + ", " + WaypointToStringTools.linearVelocityToString(linearVelocity, format) + ", " + WaypointToStringTools.angularVelocityToString(angularVelocity, format) + referenceFrameToString + "]";
    }

    public static String positionToString(Point3DReadOnly position, NumberFormat format) {
        return "position = " + WaypointToStringTools.tuple3dToString((Tuple3DReadOnly)position, format);
    }

    public static String orientationToString(QuaternionReadOnly orientation, NumberFormat format) {
        return "orientation = " + WaypointToStringTools.tuple4dToString((Tuple4DReadOnly)orientation, format);
    }

    public static String linearVelocityToString(Vector3DReadOnly linearVelocity, NumberFormat format) {
        return "linearVelocity = " + WaypointToStringTools.tuple3dToString((Tuple3DReadOnly)linearVelocity, format);
    }

    public static String angularVelocityToString(Vector3DReadOnly angularVelocity, NumberFormat format) {
        return "angular velocity = " + WaypointToStringTools.tuple3dToString((Tuple3DReadOnly)angularVelocity, format);
    }

    public static String tuple3dToString(Tuple3DReadOnly tuple, NumberFormat format) {
        String xToString = format.format(tuple.getX());
        String yToString = format.format(tuple.getY());
        String zToString = format.format(tuple.getZ());
        return "(" + xToString + ", " + yToString + ", " + zToString + ")";
    }

    public static String tuple4dToString(Tuple4DReadOnly tuple, NumberFormat format) {
        String xToString = format.format(tuple.getX());
        String yToString = format.format(tuple.getY());
        String zToString = format.format(tuple.getZ());
        String sToString = format.format(tuple.getS());
        return "(" + xToString + ", " + yToString + ", " + zToString + ", " + sToString + ")";
    }

    public static String format(double number) {
        return format.format(number);
    }

    public static String formatTime(double number) {
        return timeFormat.format(number);
    }
}

