/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public interface SO3WaypointBasics
extends Transformable,
Clearable {
    public QuaternionReadOnly getOrientation();

    public void setOrientation(double var1, double var3, double var5, double var7);

    public Vector3DReadOnly getAngularVelocity();

    public void setAngularVelocity(double var1, double var3, double var5);

    default public double getOrientationX() {
        return this.getOrientation().getX();
    }

    default public double getOrientationY() {
        return this.getOrientation().getY();
    }

    default public double getOrientationZ() {
        return this.getOrientation().getZ();
    }

    default public double getOrientationS() {
        return this.getOrientation().getS();
    }

    default public double getAngularVelocityX() {
        return this.getAngularVelocity().getX();
    }

    default public double getAngularVelocityY() {
        return this.getAngularVelocity().getY();
    }

    default public double getAngularVelocityZ() {
        return this.getAngularVelocity().getZ();
    }

    default public void setOrientation(QuaternionReadOnly orientation) {
        this.setOrientation(orientation.getX(), orientation.getY(), orientation.getZ(), orientation.getS());
    }

    default public void setOrientationToZero() {
        this.setOrientation(0.0, 0.0, 0.0, 1.0);
    }

    default public void setOrientationToNaN() {
        this.setOrientation(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    default public void setAngularVelocity(Vector3DReadOnly angularVelocity) {
        this.setAngularVelocity(angularVelocity.getX(), angularVelocity.getY(), angularVelocity.getZ());
    }

    default public void setAngularVelocityToZero() {
        this.setAngularVelocity(0.0, 0.0, 0.0);
    }

    default public void setAngularVelocityToNaN() {
        this.setAngularVelocity(Double.NaN, Double.NaN, Double.NaN);
    }

    default public double orientationDistance(SO3WaypointBasics other) {
        return this.getOrientation().distance(other.getOrientation());
    }

    default public void getOrientation(QuaternionBasics orientationToPack) {
        orientationToPack.set(this.getOrientation());
    }

    default public void getAngularVelocity(Vector3DBasics angularVelocityToPack) {
        angularVelocityToPack.set((Tuple3DReadOnly)this.getAngularVelocity());
    }

    default public void set(QuaternionReadOnly orientation, Vector3DReadOnly angularVelocity) {
        this.setOrientation(orientation);
        this.setAngularVelocity(angularVelocity);
    }

    default public void get(SO3WaypointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public void get(QuaternionBasics orientationToPack, Vector3DBasics angularVelocityToPack) {
        this.getOrientation(orientationToPack);
        this.getAngularVelocity(angularVelocityToPack);
    }

    default public boolean epsilonEquals(SO3WaypointBasics other, double epsilon) {
        boolean orientationMatches = this.getOrientation().epsilonEquals((Tuple4DReadOnly)other.getOrientation(), epsilon);
        boolean angularVelocityMatches = this.getAngularVelocity().epsilonEquals((Tuple3DReadOnly)other.getAngularVelocity(), epsilon);
        return orientationMatches && angularVelocityMatches;
    }

    default public boolean geometricallyEquals(SO3WaypointBasics other, double epsilon) {
        boolean orientationMatches = this.getOrientation().geometricallyEquals(other.getOrientation(), epsilon);
        boolean angularVelocityMatches = this.getAngularVelocity().geometricallyEquals(other.getAngularVelocity(), epsilon);
        return orientationMatches && angularVelocityMatches;
    }

    default public void set(SO3WaypointBasics other) {
        this.setOrientation(other.getOrientation());
        this.setAngularVelocity(other.getAngularVelocity());
    }

    default public void setToNaN() {
        this.setOrientationToNaN();
        this.setAngularVelocityToNaN();
    }

    default public void setToZero() {
        this.setOrientationToZero();
        this.setAngularVelocityToZero();
    }

    default public boolean containsNaN() {
        return this.getOrientation().containsNaN() || this.getAngularVelocity().containsNaN();
    }

    default public QuaternionBasics getOrientationCopy() {
        return new Quaternion(this.getOrientation());
    }

    default public Vector3DBasics getAngularVelocityCopy() {
        return new Vector3D((Tuple3DReadOnly)this.getAngularVelocity());
    }
}

