/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointBasics;

public interface SE3WaypointBasics
extends EuclideanWaypointBasics,
SO3WaypointBasics {
    default public void set(Point3DReadOnly position, QuaternionReadOnly orientation, Vector3DReadOnly linearVelocity, Vector3DReadOnly angularVelocity) {
        this.setPosition(position);
        this.setOrientation(orientation);
        this.setLinearVelocity(linearVelocity);
        this.setAngularVelocity(angularVelocity);
    }

    default public void get(Point3DBasics positionToPack, QuaternionBasics orientationToPack, Vector3DBasics linearVelocityToPack, Vector3DBasics angularVelocityToPack) {
        this.getPosition(positionToPack);
        this.getOrientation(orientationToPack);
        this.getLinearVelocity(linearVelocityToPack);
        this.getAngularVelocity(angularVelocityToPack);
    }

    default public void get(SE3WaypointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public void get(EuclideanWaypointBasics euclideanWaypointToPack, SO3WaypointBasics so3WaypointToPack) {
        this.get(euclideanWaypointToPack);
        this.get(so3WaypointToPack);
    }

    default public void getPose(Pose3DBasics poseToPack) {
        poseToPack.set((Tuple3DReadOnly)this.getPosition(), (Orientation3DReadOnly)this.getOrientation());
    }

    default public boolean epsilonEquals(SE3WaypointBasics other, double epsilon) {
        boolean euclideanMatch = EuclideanWaypointBasics.super.epsilonEquals(other, epsilon);
        boolean so3Match = SO3WaypointBasics.super.epsilonEquals(other, epsilon);
        return euclideanMatch && so3Match;
    }

    default public boolean geometricallyEquals(SE3WaypointBasics other, double epsilon) {
        boolean euclideanMatch = EuclideanWaypointBasics.super.geometricallyEquals(other, epsilon);
        boolean so3Match = SO3WaypointBasics.super.geometricallyEquals(other, epsilon);
        return euclideanMatch && so3Match;
    }

    default public void set(SE3WaypointBasics other) {
        EuclideanWaypointBasics.super.set(other);
        SO3WaypointBasics.super.set(other);
    }

    @Override
    default public void setToNaN() {
        EuclideanWaypointBasics.super.setToNaN();
        SO3WaypointBasics.super.setToNaN();
    }

    @Override
    default public void setToZero() {
        EuclideanWaypointBasics.super.setToZero();
        SO3WaypointBasics.super.setToZero();
    }

    @Override
    default public boolean containsNaN() {
        return EuclideanWaypointBasics.super.containsNaN() || SO3WaypointBasics.super.containsNaN();
    }
}

