/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.tools.EuclidCoreTools;

public interface OneDoFWaypointBasics {
    public void setPosition(double var1);

    public void setVelocity(double var1);

    public double getPosition();

    public double getVelocity();

    default public void setPositionToZero() {
        this.setPosition(0.0);
    }

    default public void setVelocityToZero() {
        this.setVelocity(0.0);
    }

    default public void setPositionToNaN() {
        this.setPosition(Double.NaN);
    }

    default public void setVelocityToNaN() {
        this.setVelocity(Double.NaN);
    }

    default public void set(double position, double velocity) {
        this.setPosition(position);
        this.setVelocity(velocity);
    }

    default public void get(OneDoFWaypointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public boolean epsilonEquals(OneDoFWaypointBasics other, double epsilon) {
        return EuclidCoreTools.epsilonEquals((double)this.getPosition(), (double)other.getPosition(), (double)epsilon) && EuclidCoreTools.epsilonEquals((double)this.getVelocity(), (double)other.getVelocity(), (double)epsilon);
    }

    default public void set(OneDoFWaypointBasics other) {
        this.setPosition(other.getPosition());
        this.setVelocity(other.getVelocity());
    }

    default public void setToNaN() {
        this.setPositionToNaN();
        this.setVelocityToNaN();
    }

    default public void setToZero() {
        this.setPositionToZero();
        this.setVelocityToZero();
    }

    default public boolean containsNaN() {
        return Double.isNaN(this.getPosition()) || Double.isNaN(this.getVelocity());
    }
}

