/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointBasics;

public interface FrameSO3WaypointBasics
extends SO3WaypointBasics,
FrameChangeable {
    public FrameQuaternionReadOnly getOrientation();

    public FrameVector3DReadOnly getAngularVelocity();

    default public void setOrientation(FrameQuaternionReadOnly orientation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.setOrientation(orientation.getX(), orientation.getY(), orientation.getZ(), orientation.getS());
    }

    default public void setAngularVelocity(FrameVector3DReadOnly angularVelocity) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)angularVelocity);
        this.setAngularVelocity(angularVelocity.getX(), angularVelocity.getY(), angularVelocity.getZ());
    }

    default public double orientationDistance(FrameSO3WaypointBasics other) {
        return this.getOrientation().distance(other.getOrientation());
    }

    default public void getOrientation(FixedFrameQuaternionBasics orientationToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)orientationToPack);
        orientationToPack.set(this.getOrientation());
    }

    default public void getAngularVelocity(FixedFrameVector3DBasics angularVelocityToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)angularVelocityToPack);
        angularVelocityToPack.set((FrameTuple3DReadOnly)this.getAngularVelocity());
    }

    default public void getOrientationIncludingFrame(FrameQuaternionBasics orientationToPack) {
        orientationToPack.setIncludingFrame(this.getOrientation());
    }

    default public void getAngularVelocityIncludingFrame(FrameVector3DBasics angularVelocityToPack) {
        angularVelocityToPack.setIncludingFrame((FrameTuple3DReadOnly)this.getAngularVelocity());
    }

    default public void set(FrameQuaternionReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.setOrientation(orientation);
        this.setAngularVelocity(angularVelocity);
    }

    default public void setIncludingFrame(FrameQuaternionReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.setReferenceFrame(orientation.getReferenceFrame());
        this.set(orientation, angularVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, QuaternionReadOnly orientation, Vector3DReadOnly angularVelocity) {
        this.setReferenceFrame(referenceFrame);
        this.set(orientation, angularVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, SO3WaypointBasics other) {
        this.setReferenceFrame(referenceFrame);
        this.set(other);
    }

    default public void setIncludingFrame(FrameSO3WaypointBasics other) {
        this.setReferenceFrame(other.getReferenceFrame());
        this.set(other);
    }

    default public void get(FrameSO3WaypointBasics otherToPack) {
        otherToPack.setIncludingFrame(this);
    }

    default public void getIncludingFrame(FrameSO3WaypointBasics otherToPack) {
        otherToPack.setIncludingFrame(this);
    }

    default public void get(FixedFrameQuaternionBasics orientationToPack, FixedFrameVector3DBasics angularVelocityToPack) {
        this.getOrientation(orientationToPack);
        this.getAngularVelocity(angularVelocityToPack);
    }

    default public void getIncludingFrame(FrameQuaternionBasics orientationToPack, FrameVector3DBasics angularVelocityToPack) {
        this.getOrientationIncludingFrame(orientationToPack);
        this.getAngularVelocityIncludingFrame(angularVelocityToPack);
    }

    default public boolean epsilonEquals(FrameSO3WaypointBasics other, double epsilon) {
        boolean orientationMatches = this.getOrientation().epsilonEquals((FrameTuple4DReadOnly)other.getOrientation(), epsilon);
        boolean angularVelocityMatches = this.getAngularVelocity().epsilonEquals((FrameTuple3DReadOnly)other.getAngularVelocity(), epsilon);
        return orientationMatches && angularVelocityMatches;
    }

    default public boolean geometricallyEquals(FrameSO3WaypointBasics other, double epsilon) {
        boolean orientationMatches = this.getOrientation().geometricallyEquals(other.getOrientation(), epsilon);
        boolean angularVelocityMatches = this.getAngularVelocity().geometricallyEquals(other.getAngularVelocity(), epsilon);
        return orientationMatches && angularVelocityMatches;
    }

    default public void set(FrameSO3WaypointBasics other) {
        this.setOrientation(other.getOrientation());
        this.setAngularVelocity(other.getAngularVelocity());
    }

    default public void setToNaN(ReferenceFrame referenceFrame) {
        this.setReferenceFrame(referenceFrame);
        this.setToNaN();
    }

    default public void setToZero(ReferenceFrame referenceFrame) {
        this.setReferenceFrame(referenceFrame);
        this.setToZero();
    }

    default public FrameQuaternionBasics getOrientationCopy() {
        return new FrameQuaternion(this.getOrientation());
    }

    default public FrameVector3DBasics getAngularVelocityCopy() {
        return new FrameVector3D((FrameTuple3DReadOnly)this.getAngularVelocity());
    }
}

