/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SE3WaypointBasics;

public interface FrameSE3WaypointBasics
extends FrameEuclideanWaypointBasics,
FrameSO3WaypointBasics,
SE3WaypointBasics {
    default public void set(FramePoint3DReadOnly position, FrameQuaternionReadOnly orientation, FrameVector3DReadOnly linearVelocity, FrameVector3DReadOnly angularVelocity) {
        this.setPosition(position);
        this.setOrientation(orientation);
        this.setLinearVelocity(linearVelocity);
        this.setAngularVelocity(angularVelocity);
    }

    default public void setIncludingFrame(FramePoint3DReadOnly position, FrameQuaternionReadOnly orientation, FrameVector3DReadOnly linearVelocity, FrameVector3DReadOnly angularVelocity) {
        this.setReferenceFrame(position.getReferenceFrame());
        this.setPosition(position);
        this.setOrientation(orientation);
        this.setLinearVelocity(linearVelocity);
        this.setAngularVelocity(angularVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, Point3DReadOnly position, QuaternionReadOnly orientation, Vector3DReadOnly linearVelocity, Vector3DReadOnly angularVelocity) {
        this.setReferenceFrame(referenceFrame);
        this.setPosition(position);
        this.setOrientation(orientation);
        this.setLinearVelocity(linearVelocity);
        this.setAngularVelocity(angularVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, SE3WaypointBasics other) {
        this.setReferenceFrame(referenceFrame);
        this.set(other);
    }

    default public void setIncludingFrame(FrameSE3WaypointBasics other) {
        this.setReferenceFrame(other.getReferenceFrame());
        this.set(other);
    }

    default public void get(FrameSE3WaypointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public void getIncludingFrame(FrameSE3WaypointBasics otherToPack) {
        otherToPack.setIncludingFrame(this);
    }

    default public void get(FrameEuclideanWaypointBasics euclideanWaypointToPack, FrameSO3WaypointBasics so3WaypointToPack) {
        this.get(euclideanWaypointToPack);
        this.get(so3WaypointToPack);
    }

    default public void getIncludingFrame(FrameEuclideanWaypointBasics euclideanWaypointToPack, FrameSO3WaypointBasics so3WaypointToPack) {
        this.getIncludingFrame(euclideanWaypointToPack);
        this.getIncludingFrame(so3WaypointToPack);
    }

    default public void get(FixedFramePoint3DBasics positionToPack, FixedFrameQuaternionBasics orientationToPack, FixedFrameVector3DBasics linearVelocityToPack, FixedFrameVector3DBasics angularVelocityToPack) {
        this.getPosition(positionToPack);
        this.getOrientation(orientationToPack);
        this.getLinearVelocity(linearVelocityToPack);
        this.getAngularVelocity(angularVelocityToPack);
    }

    default public void getIncludingFrame(FramePoint3DBasics positionToPack, FrameQuaternionBasics orientationToPack, FrameVector3DBasics linearVelocityToPack, FrameVector3DBasics angularVelocityToPack) {
        this.getPositionIncludingFrame(positionToPack);
        this.getOrientationIncludingFrame(orientationToPack);
        this.getLinearVelocityIncludingFrame(linearVelocityToPack);
        this.getAngularVelocityIncludingFrame(angularVelocityToPack);
    }

    default public void getPose(FixedFramePose3DBasics poseToPack) {
        poseToPack.set((FrameTuple3DReadOnly)this.getPosition(), (FrameOrientation3DReadOnly)this.getOrientation());
    }

    default public void getPoseIncludingFrame(FramePose3DBasics poseToPack) {
        poseToPack.setIncludingFrame((FrameTuple3DReadOnly)this.getPosition(), (FrameOrientation3DReadOnly)this.getOrientation());
    }

    default public boolean epsilonEquals(FrameSE3WaypointBasics other, double epsilon) {
        boolean euclideanMatch = FrameEuclideanWaypointBasics.super.epsilonEquals(other, epsilon);
        boolean so3Match = FrameSO3WaypointBasics.super.epsilonEquals(other, epsilon);
        return euclideanMatch && so3Match;
    }

    default public boolean geometricallyEquals(FrameSE3WaypointBasics other, double epsilon) {
        boolean euclideanMatch = FrameEuclideanWaypointBasics.super.geometricallyEquals(other, epsilon);
        boolean so3Match = FrameSO3WaypointBasics.super.geometricallyEquals(other, epsilon);
        return euclideanMatch && so3Match;
    }

    default public void set(FrameSE3WaypointBasics other) {
        FrameEuclideanWaypointBasics.super.set(other);
        FrameSO3WaypointBasics.super.set(other);
    }

    @Override
    default public void setToNaN(ReferenceFrame referenceFrame) {
        FrameEuclideanWaypointBasics.super.setToNaN(referenceFrame);
        FrameSO3WaypointBasics.super.setToNaN(referenceFrame);
    }

    @Override
    default public void setToZero(ReferenceFrame referenceFrame) {
        FrameEuclideanWaypointBasics.super.setToZero(referenceFrame);
        FrameSO3WaypointBasics.super.setToZero(referenceFrame);
    }
}

