/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointBasics;

public interface FrameEuclideanWaypointBasics
extends EuclideanWaypointBasics,
FrameChangeable {
    public FramePoint3DReadOnly getPosition();

    public FrameVector3DReadOnly getLinearVelocity();

    default public void setPosition(FramePoint3DReadOnly position) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)position);
        this.setPosition(position.getX(), position.getY(), position.getZ());
    }

    default public void setLinearVelocity(FrameVector3DReadOnly linearVelocity) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)linearVelocity);
        this.setLinearVelocity(linearVelocity.getX(), linearVelocity.getY(), linearVelocity.getZ());
    }

    default public double positionDistance(FrameEuclideanWaypointBasics other) {
        return this.getPosition().distance(other.getPosition());
    }

    default public void getPosition(FixedFramePoint3DBasics positionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)positionToPack);
        positionToPack.set((FrameTuple3DReadOnly)this.getPosition());
    }

    default public void getLinearVelocity(FixedFrameVector3DBasics linearVelocityToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)linearVelocityToPack);
        linearVelocityToPack.set((FrameTuple3DReadOnly)this.getLinearVelocity());
    }

    default public void getPositionIncludingFrame(FramePoint3DBasics positionToPack) {
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)this.getPosition());
    }

    default public void getLinearVelocityIncludingFrame(FrameVector3DBasics linearVelocityToPack) {
        linearVelocityToPack.setIncludingFrame((FrameTuple3DReadOnly)this.getLinearVelocity());
    }

    default public void set(FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.setPosition(position);
        this.setLinearVelocity(linearVelocity);
    }

    default public void setIncludingFrame(FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.setReferenceFrame(position.getReferenceFrame());
        this.set(position, linearVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        this.setReferenceFrame(referenceFrame);
        this.set(position, linearVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, EuclideanWaypointBasics other) {
        this.setReferenceFrame(referenceFrame);
        this.set(other);
    }

    default public void setIncludingFrame(FrameEuclideanWaypointBasics other) {
        this.setReferenceFrame(other.getReferenceFrame());
        this.set(other);
    }

    default public void get(FrameEuclideanWaypointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public void getIncludingFrame(FrameEuclideanWaypointBasics otherToPack) {
        otherToPack.setIncludingFrame(this);
    }

    default public void get(FixedFramePoint3DBasics positionToPack, FixedFrameVector3DBasics linearVelocityToPack) {
        this.getPosition(positionToPack);
        this.getLinearVelocity(linearVelocityToPack);
    }

    default public void getIncludingFrame(FramePoint3DBasics positionToPack, FrameVector3DBasics linearVelocityToPack) {
        this.getPositionIncludingFrame(positionToPack);
        this.getLinearVelocityIncludingFrame(linearVelocityToPack);
    }

    default public boolean epsilonEquals(FrameEuclideanWaypointBasics other, double epsilon) {
        boolean positionMatches = this.getPosition().epsilonEquals((FrameTuple3DReadOnly)other.getPosition(), epsilon);
        boolean linearVelocityMatches = this.getLinearVelocity().epsilonEquals((FrameTuple3DReadOnly)other.getLinearVelocity(), epsilon);
        return positionMatches && linearVelocityMatches;
    }

    default public boolean geometricallyEquals(FrameEuclideanWaypointBasics other, double epsilon) {
        boolean positionMatches = this.getPosition().geometricallyEquals(other.getPosition(), epsilon);
        boolean linearVelocityMatches = this.getLinearVelocity().geometricallyEquals(other.getLinearVelocity(), epsilon);
        return positionMatches && linearVelocityMatches;
    }

    default public void set(FrameEuclideanWaypointBasics other) {
        this.setPosition(other.getPosition());
        this.setLinearVelocity(other.getLinearVelocity());
    }

    default public void setToNaN(ReferenceFrame referenceFrame) {
        this.setReferenceFrame(referenceFrame);
        this.setToNaN();
    }

    default public void setToZero(ReferenceFrame referenceFrame) {
        this.setReferenceFrame(referenceFrame);
        this.setToZero();
    }

    default public FramePoint3DBasics getPositionCopy() {
        return new FramePoint3D((FrameTuple3DReadOnly)this.getPosition());
    }

    default public FrameVector3DBasics getLinearVelocityCopy() {
        return new FrameVector3D((FrameTuple3DReadOnly)this.getLinearVelocity());
    }
}

