/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface EuclideanWaypointBasics
extends Transformable,
Clearable {
    public Point3DReadOnly getPosition();

    public void setPosition(double var1, double var3, double var5);

    public Vector3DReadOnly getLinearVelocity();

    public void setLinearVelocity(double var1, double var3, double var5);

    default public double getPositionX() {
        return this.getPosition().getX();
    }

    default public double getPositionY() {
        return this.getPosition().getY();
    }

    default public double getPositionZ() {
        return this.getPosition().getZ();
    }

    default public double getLinearVelocityX() {
        return this.getLinearVelocity().getX();
    }

    default public double getLinearVelocityY() {
        return this.getLinearVelocity().getY();
    }

    default public double getLinearVelocityZ() {
        return this.getLinearVelocity().getZ();
    }

    default public void setPosition(Point3DReadOnly position) {
        this.setPosition(position.getX(), position.getY(), position.getZ());
    }

    default public void setPositionToZero() {
        this.setPosition(0.0, 0.0, 0.0);
    }

    default public void setPositionToNaN() {
        this.setPosition(Double.NaN, Double.NaN, Double.NaN);
    }

    default public void setLinearVelocity(Vector3DReadOnly linearVelocity) {
        this.setLinearVelocity(linearVelocity.getX(), linearVelocity.getY(), linearVelocity.getZ());
    }

    default public void setLinearVelocityToZero() {
        this.setLinearVelocity(0.0, 0.0, 0.0);
    }

    default public void setLinearVelocityToNaN() {
        this.setLinearVelocity(Double.NaN, Double.NaN, Double.NaN);
    }

    default public double positionDistance(EuclideanWaypointBasics other) {
        return this.getPosition().distance(other.getPosition());
    }

    default public void getPosition(Point3DBasics positionToPack) {
        positionToPack.set((Tuple3DReadOnly)this.getPosition());
    }

    default public void getLinearVelocity(Vector3DBasics linearVelocityToPack) {
        linearVelocityToPack.set((Tuple3DReadOnly)this.getLinearVelocity());
    }

    default public void set(Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        this.setPosition(position);
        this.setLinearVelocity(linearVelocity);
    }

    default public void get(Point3DBasics positionToPack, Vector3DBasics linearVelocityToPack) {
        this.getPosition(positionToPack);
        this.getLinearVelocity(linearVelocityToPack);
    }

    default public void get(EuclideanWaypointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public boolean epsilonEquals(EuclideanWaypointBasics other, double epsilon) {
        boolean positionMatches = this.getPosition().epsilonEquals((Tuple3DReadOnly)other.getPosition(), epsilon);
        boolean linearVelocityMatches = this.getLinearVelocity().epsilonEquals((Tuple3DReadOnly)other.getLinearVelocity(), epsilon);
        return positionMatches && linearVelocityMatches;
    }

    default public boolean geometricallyEquals(EuclideanWaypointBasics other, double epsilon) {
        boolean positionMatches = this.getPosition().geometricallyEquals(other.getPosition(), epsilon);
        boolean linearVelocityMatches = this.getLinearVelocity().geometricallyEquals(other.getLinearVelocity(), epsilon);
        return positionMatches && linearVelocityMatches;
    }

    default public void set(EuclideanWaypointBasics other) {
        this.setPosition(other.getPosition());
        this.setLinearVelocity(other.getLinearVelocity());
    }

    default public void setToNaN() {
        this.setPositionToNaN();
        this.setLinearVelocityToNaN();
    }

    default public void setToZero() {
        this.setPositionToZero();
        this.setLinearVelocityToZero();
    }

    default public boolean containsNaN() {
        return this.getPosition().containsNaN() || this.getLinearVelocity().containsNaN();
    }

    default public Point3DBasics getPositionCopy() {
        return new Point3D((Tuple3DReadOnly)this.getPosition());
    }

    default public Vector3DBasics getLinearVelocityCopy() {
        return new Vector3D((Tuple3DReadOnly)this.getLinearVelocity());
    }
}

