/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.text.DecimalFormat;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.OneDoFWaypointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoOneDoFWaypoint
implements OneDoFWaypointBasics {
    private final String namePrefix;
    private final String nameSuffix;
    private final YoDouble position;
    private final YoDouble velocity;

    public YoOneDoFWaypoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.position = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "position", nameSuffix}), registry);
        this.velocity = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "velocity", nameSuffix}), registry);
    }

    @Override
    public void setPosition(double position) {
        this.position.set(position);
    }

    @Override
    public void setVelocity(double velocity) {
        this.velocity.set(velocity);
    }

    @Override
    public double getPosition() {
        return this.position.getDoubleValue();
    }

    @Override
    public double getVelocity() {
        return this.velocity.getDoubleValue();
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public String toString() {
        DecimalFormat doubleFormat = new DecimalFormat(" 0.00;-0.00");
        String positionString = "position = " + doubleFormat.format(this.getPosition());
        String velocityString = "velocity = " + doubleFormat.format(this.getVelocity());
        return "Waypoint 1D: (" + positionString + ", " + velocityString + ")";
    }
}

