/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.tools.WaypointToStringTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFrameSO3Waypoint
implements FrameSO3WaypointBasics {
    private final FrameQuaternionBasics orientation;
    private final FrameVector3DBasics angularVelocity;

    public YoFrameSO3Waypoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.orientation = new YoMutableFrameQuaternion(namePrefix + "Orientation", nameSuffix, registry);
        this.angularVelocity = new YoMutableFrameVector3D(namePrefix + "AngularVelocity", nameSuffix, registry);
    }

    @Override
    public void setOrientation(double x, double y, double z, double s) {
        this.orientation.set(x, y, z, s);
    }

    @Override
    public void setAngularVelocity(double x, double y, double z) {
        this.angularVelocity.set(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.orientation.applyTransform(transform);
        this.angularVelocity.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.orientation.applyInverseTransform(transform);
        this.angularVelocity.applyInverseTransform(transform);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.orientation.setReferenceFrame(referenceFrame);
        this.angularVelocity.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        this.orientation.checkReferenceFrameMatch((ReferenceFrameHolder)this.angularVelocity);
        return this.orientation.getReferenceFrame();
    }

    @Override
    public FrameQuaternionReadOnly getOrientation() {
        return this.orientation;
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.angularVelocity;
    }

    public String toString() {
        return WaypointToStringTools.waypointToString(this);
    }
}

