/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.tools.WaypointToStringTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameEuclideanWaypoint
implements FrameEuclideanWaypointBasics {
    private final YoMutableFramePoint3D position;
    private final YoMutableFrameVector3D linearVelocity;

    public YoFrameEuclideanWaypoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.position = new YoMutableFramePoint3D(namePrefix + "Position", nameSuffix, registry);
        this.linearVelocity = new YoMutableFrameVector3D(namePrefix + "LinearVelocity", nameSuffix, registry);
    }

    public YoDouble getYoX() {
        return this.position.getYoX();
    }

    public YoDouble getYoY() {
        return this.position.getYoY();
    }

    public YoDouble getYoZ() {
        return this.position.getYoZ();
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.position;
    }

    @Override
    public FrameVector3DReadOnly getLinearVelocity() {
        return this.linearVelocity;
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
    }

    @Override
    public void setLinearVelocity(double x, double y, double z) {
        this.linearVelocity.set(x, y, z);
    }

    public ReferenceFrame getReferenceFrame() {
        this.position.checkReferenceFrameMatch((ReferenceFrameHolder)this.linearVelocity);
        return this.position.getReferenceFrame();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.position.setReferenceFrame(referenceFrame);
        this.linearVelocity.setReferenceFrame(referenceFrame);
    }

    public void applyTransform(Transform transform) {
        this.position.applyTransform(transform);
        this.linearVelocity.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.position.applyInverseTransform(transform);
        this.linearVelocity.applyInverseTransform(transform);
    }

    public String toString() {
        return WaypointToStringTools.waypointToString(this);
    }
}

