/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.tools.WaypointToStringTools;

public class SO3Waypoint
implements SO3WaypointBasics {
    private final Quaternion orientation = new Quaternion();
    private final Vector3D angularVelocity = new Vector3D();

    @Override
    public QuaternionReadOnly getOrientation() {
        return this.orientation;
    }

    @Override
    public Vector3DReadOnly getAngularVelocity() {
        return this.angularVelocity;
    }

    @Override
    public void setOrientation(double x, double y, double z, double s) {
        this.orientation.set(x, y, z, s);
    }

    @Override
    public void setAngularVelocity(double x, double y, double z) {
        this.angularVelocity.set(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.orientation.applyTransform(transform);
        this.angularVelocity.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.orientation.applyInverseTransform(transform);
        this.angularVelocity.applyInverseTransform(transform);
    }

    public String toString() {
        return WaypointToStringTools.waypointToString(this);
    }
}

