/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.EuclideanWaypoint;
import us.ihmc.robotics.math.trajectories.waypoints.SO3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SE3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.tools.WaypointToStringTools;

public class SE3Waypoint
implements SE3WaypointBasics {
    private final EuclideanWaypoint euclideanWaypoint = new EuclideanWaypoint();
    private final SO3Waypoint so3Waypoint = new SO3Waypoint();

    @Override
    public void setPosition(double x, double y, double z) {
        this.euclideanWaypoint.setPosition(x, y, z);
    }

    @Override
    public void setOrientation(double x, double y, double z, double s) {
        this.so3Waypoint.setOrientation(x, y, z, s);
    }

    @Override
    public void setLinearVelocity(double x, double y, double z) {
        this.euclideanWaypoint.setLinearVelocity(x, y, z);
    }

    @Override
    public void setAngularVelocity(double x, double y, double z) {
        this.so3Waypoint.setAngularVelocity(x, y, z);
    }

    @Override
    public Point3DReadOnly getPosition() {
        return this.euclideanWaypoint.getPosition();
    }

    @Override
    public QuaternionReadOnly getOrientation() {
        return this.so3Waypoint.getOrientation();
    }

    @Override
    public Vector3DReadOnly getLinearVelocity() {
        return this.euclideanWaypoint.getLinearVelocity();
    }

    @Override
    public Vector3DReadOnly getAngularVelocity() {
        return this.so3Waypoint.getAngularVelocity();
    }

    public void applyTransform(Transform transform) {
        this.euclideanWaypoint.applyTransform(transform);
        this.so3Waypoint.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.euclideanWaypoint.applyInverseTransform(transform);
        this.so3Waypoint.applyInverseTransform(transform);
    }

    public EuclideanWaypoint getEuclideanWaypoint() {
        return this.euclideanWaypoint;
    }

    public SO3Waypoint getSO3Waypoint() {
        return this.so3Waypoint;
    }

    public String toString() {
        return WaypointToStringTools.waypointToString(this);
    }
}

