/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointBasics;

public class FrameSO3Waypoint
implements FrameSO3WaypointBasics {
    private final FrameQuaternion orientation = new FrameQuaternion();
    private final FrameVector3D angularVelocity = new FrameVector3D();

    public FrameSO3Waypoint() {
    }

    public FrameSO3Waypoint(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    @Override
    public void setOrientation(double x, double y, double z, double s) {
        this.orientation.set(x, y, z, s);
    }

    @Override
    public void setAngularVelocity(double x, double y, double z) {
        this.angularVelocity.set(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.orientation.applyTransform(transform);
        this.angularVelocity.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.orientation.applyInverseTransform(transform);
        this.angularVelocity.applyInverseTransform(transform);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.orientation.setReferenceFrame(referenceFrame);
        this.angularVelocity.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        this.orientation.checkReferenceFrameMatch((ReferenceFrameHolder)this.angularVelocity);
        return this.orientation.getReferenceFrame();
    }

    @Override
    public FrameQuaternionReadOnly getOrientation() {
        return this.orientation;
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.angularVelocity;
    }
}

