/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.math.trajectories.waypoints.FrameEuclideanWaypoint;
import us.ihmc.robotics.math.trajectories.waypoints.FrameSO3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSE3WaypointBasics;

public class FrameSE3Waypoint
implements FrameSE3WaypointBasics {
    private final FrameEuclideanWaypoint euclideanWaypoint = new FrameEuclideanWaypoint();
    private final FrameSO3Waypoint so3Waypoint = new FrameSO3Waypoint();

    public FrameSE3Waypoint() {
    }

    public FrameSE3Waypoint(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.euclideanWaypoint.getPosition();
    }

    @Override
    public FrameVector3DReadOnly getLinearVelocity() {
        return this.euclideanWaypoint.getLinearVelocity();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.euclideanWaypoint.setPosition(x, y, z);
    }

    @Override
    public void setLinearVelocity(double x, double y, double z) {
        this.euclideanWaypoint.setLinearVelocity(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.euclideanWaypoint.applyTransform(transform);
        this.so3Waypoint.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.euclideanWaypoint.applyInverseTransform(transform);
        this.so3Waypoint.applyInverseTransform(transform);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.euclideanWaypoint.setReferenceFrame(referenceFrame);
        this.so3Waypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        this.euclideanWaypoint.checkReferenceFrameMatch((ReferenceFrameHolder)this.so3Waypoint);
        return this.euclideanWaypoint.getReferenceFrame();
    }

    @Override
    public FrameQuaternionReadOnly getOrientation() {
        return this.so3Waypoint.getOrientation();
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.so3Waypoint.getAngularVelocity();
    }

    @Override
    public void setOrientation(double x, double y, double z, double s) {
        this.so3Waypoint.setOrientation(x, y, z, s);
    }

    @Override
    public void setAngularVelocity(double x, double y, double z) {
        this.so3Waypoint.setAngularVelocity(x, y, z);
    }
}

