/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointBasics;

public class FrameEuclideanWaypoint
implements FrameEuclideanWaypointBasics {
    private final FramePoint3D position = new FramePoint3D();
    private final FrameVector3D linearVelocity = new FrameVector3D();

    public FrameEuclideanWaypoint() {
    }

    public FrameEuclideanWaypoint(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
    }

    @Override
    public void setLinearVelocity(double x, double y, double z) {
        this.linearVelocity.set(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.position.applyTransform(transform);
        this.linearVelocity.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.position.applyInverseTransform(transform);
        this.linearVelocity.applyInverseTransform(transform);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.position.setReferenceFrame(referenceFrame);
        this.linearVelocity.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        this.position.checkReferenceFrameMatch((ReferenceFrameHolder)this.linearVelocity);
        return this.position.getReferenceFrame();
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.position;
    }

    @Override
    public FrameVector3DReadOnly getLinearVelocity() {
        return this.linearVelocity;
    }
}

