/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.tools.WaypointToStringTools;

public class EuclideanWaypoint
implements EuclideanWaypointBasics {
    private final Point3D position = new Point3D();
    private final Vector3D linearVelocity = new Vector3D();

    @Override
    public Point3DReadOnly getPosition() {
        return this.position;
    }

    @Override
    public Vector3DReadOnly getLinearVelocity() {
        return this.linearVelocity;
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
    }

    @Override
    public void setLinearVelocity(double x, double y, double z) {
        this.linearVelocity.set(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.position.applyTransform(transform);
        this.linearVelocity.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.position.applyInverseTransform(transform);
        this.linearVelocity.applyInverseTransform(transform);
    }

    public String toString() {
        return WaypointToStringTools.waypointToString(this);
    }
}

