/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.lists;

import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameTrajectoryPointListBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.FrameEuclideanTrajectoryPointList;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.FrameSO3TrajectoryPointList;

public class FrameSE3TrajectoryPointList
implements FrameTrajectoryPointListBasics<FrameSE3TrajectoryPoint> {
    private ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
    private final RecyclingArrayList<FrameSE3TrajectoryPoint> trajectoryPoints = new RecyclingArrayList(FrameSE3TrajectoryPoint.class);

    @Override
    public void clear() {
        this.trajectoryPoints.clear();
    }

    public void setToOrientationTrajectoryIncludingFrame(FrameSO3TrajectoryPointList trajectoryPointList) {
        this.clear(trajectoryPointList.getReferenceFrame());
        for (int i = 0; i < trajectoryPointList.getNumberOfTrajectoryPoints(); ++i) {
            this.addOrientationTrajectoryPoint(trajectoryPointList.getTrajectoryPoint(i));
        }
    }

    public void addOrientationTrajectoryPoint(double time, QuaternionReadOnly orientation, Vector3DReadOnly angularVelocity) {
        FrameSE3TrajectoryPoint newTrajectoryPoint = (FrameSE3TrajectoryPoint)this.trajectoryPoints.add();
        newTrajectoryPoint.setToZero(this.getReferenceFrame());
        newTrajectoryPoint.set(time, orientation, angularVelocity);
    }

    public void addOrientationTrajectoryPoint(FrameSO3TrajectoryPoint trajectoryPoint) {
        FrameSE3TrajectoryPoint newTrajectoryPoint = (FrameSE3TrajectoryPoint)this.trajectoryPoints.add();
        newTrajectoryPoint.setToZero(this.getReferenceFrame());
        newTrajectoryPoint.set(trajectoryPoint);
    }

    public void setToPositionTrajectoryIncludingFrame(FrameEuclideanTrajectoryPointList trajectoryPointList) {
        this.clear(trajectoryPointList.getReferenceFrame());
        for (int i = 0; i < trajectoryPointList.getNumberOfTrajectoryPoints(); ++i) {
            this.addPositionTrajectoryPoint(trajectoryPointList.getTrajectoryPoint(i));
        }
    }

    public void addPositionTrajectoryPoint(double time, Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        FrameSE3TrajectoryPoint newTrajectoryPoint = (FrameSE3TrajectoryPoint)this.trajectoryPoints.add();
        newTrajectoryPoint.setToZero(this.getReferenceFrame());
        newTrajectoryPoint.set(time, position, linearVelocity);
    }

    public void addPositionTrajectoryPoint(FrameEuclideanTrajectoryPoint trajectoryPoint) {
        FrameSE3TrajectoryPoint newTrajectoryPoint = (FrameSE3TrajectoryPoint)this.trajectoryPoints.add();
        newTrajectoryPoint.setToZero(this.getReferenceFrame());
        newTrajectoryPoint.set(trajectoryPoint);
    }

    public void addTrajectoryPoint(double time, Point3DReadOnly position, QuaternionReadOnly orientation, Vector3DReadOnly linearVelocity, Vector3DReadOnly angularVelocity) {
        ((FrameSE3TrajectoryPoint)this.trajectoryPoints.add()).setIncludingFrame(this.getReferenceFrame(), time, position, orientation, linearVelocity, angularVelocity);
    }

    @Override
    public void addTrajectoryPoint(FrameSE3TrajectoryPoint trajectoryPoint) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)trajectoryPoint);
        ((FrameSE3TrajectoryPoint)this.trajectoryPoints.add()).setIncludingFrame(trajectoryPoint);
    }

    @Override
    public void addTrajectoryPoint(SE3TrajectoryPointBasics trajectoryPoint) {
        FrameSE3TrajectoryPoint newTrajectoryPoint = (FrameSE3TrajectoryPoint)this.trajectoryPoints.add();
        newTrajectoryPoint.setToZero(this.getReferenceFrame());
        newTrajectoryPoint.set(trajectoryPoint);
    }

    @Override
    public FrameSE3TrajectoryPoint getTrajectoryPoint(int trajectoryPointIndex) {
        return (FrameSE3TrajectoryPoint)this.trajectoryPoints.get(trajectoryPointIndex);
    }

    @Override
    public int getNumberOfTrajectoryPoints() {
        return this.trajectoryPoints.size();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
        for (int i = 0; i < this.trajectoryPoints.size(); ++i) {
            ((FrameSE3TrajectoryPoint)this.trajectoryPoints.get(i)).setReferenceFrame(referenceFrame);
        }
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public String toString() {
        return "Frame SE3 trajectory: number of frame SE3 trajectory points = " + this.getNumberOfTrajectoryPoints() + ".";
    }
}

