/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointBasics;

public interface SO3TrajectoryPointBasics
extends TrajectoryPointBasics,
SO3WaypointBasics {
    default public void set(double time, QuaternionReadOnly orientation, Vector3DReadOnly angularVelocity) {
        this.setTime(time);
        this.set(orientation, angularVelocity);
    }

    default public void set(SO3TrajectoryPointBasics other) {
        this.setTime(other.getTime());
        SO3WaypointBasics.super.set(other);
    }

    default public void set(double time, SO3WaypointBasics waypoint) {
        this.setTime(time);
        this.set(waypoint);
    }

    default public void get(SO3TrajectoryPointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public boolean epsilonEquals(SO3TrajectoryPointBasics other, double epsilon) {
        boolean timeEquals = EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon);
        return timeEquals && SO3WaypointBasics.super.epsilonEquals(other, epsilon);
    }

    @Override
    default public void setToNaN() {
        this.setTimeToNaN();
        SO3WaypointBasics.super.setToNaN();
    }

    @Override
    default public void setToZero() {
        this.setTimeToZero();
        SO3WaypointBasics.super.setToZero();
    }

    @Override
    default public boolean containsNaN() {
        return Double.isNaN(this.getTime()) || SO3WaypointBasics.super.containsNaN();
    }
}

