/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SE3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointBasics;

public interface SE3TrajectoryPointBasics
extends TrajectoryPointBasics,
SE3WaypointBasics,
EuclideanTrajectoryPointBasics,
SO3TrajectoryPointBasics {
    default public void set(double time, Point3DReadOnly position, QuaternionReadOnly orientation, Vector3DReadOnly linearVelocity, Vector3DReadOnly angularVelocity) {
        this.setTime(time);
        this.set(position, orientation, linearVelocity, angularVelocity);
    }

    default public void set(SE3TrajectoryPointBasics other) {
        this.setTime(other.getTime());
        SE3WaypointBasics.super.set(other);
    }

    default public void set(double time, SE3WaypointBasics waypoint) {
        this.setTime(time);
        this.set(waypoint);
    }

    default public void set(double time, EuclideanWaypointBasics euclideanWaypoint, SO3WaypointBasics so3Waypoint) {
        this.setTime(time);
        this.set(euclideanWaypoint);
        this.set(so3Waypoint);
    }

    default public void get(SE3TrajectoryPointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public void get(EuclideanTrajectoryPointBasics euclideanTrajectoryPointToPack, SO3TrajectoryPointBasics so3TrajectoryPointToPack) {
        this.get(euclideanTrajectoryPointToPack);
        this.get(so3TrajectoryPointToPack);
    }

    default public boolean epsilonEquals(SE3TrajectoryPointBasics other, double epsilon) {
        boolean timeEquals = EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon);
        return timeEquals && SE3WaypointBasics.super.epsilonEquals(other, epsilon);
    }

    @Override
    default public void setToNaN() {
        this.setTimeToNaN();
        SE3WaypointBasics.super.setToNaN();
    }

    @Override
    default public void setToZero() {
        this.setTimeToZero();
        SE3WaypointBasics.super.setToZero();
    }

    @Override
    default public boolean containsNaN() {
        return Double.isNaN(this.getTime()) || SE3WaypointBasics.super.containsNaN();
    }
}

