/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointBasics;

public interface FrameSO3TrajectoryPointBasics
extends SO3TrajectoryPointBasics,
FrameSO3WaypointBasics {
    default public void set(double time, FrameQuaternionReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.setTime(time);
        this.set(orientation, angularVelocity);
    }

    default public void set(double time, FrameSO3WaypointBasics waypoint) {
        this.setTime(time);
        this.set(waypoint);
    }

    default public void setIncludingFrame(double time, FrameSO3WaypointBasics waypoint) {
        this.setTime(time);
        this.setIncludingFrame(waypoint);
    }

    default public void setIncludingFrame(double time, FrameQuaternionReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.setTime(time);
        this.setIncludingFrame(orientation, angularVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, double time, QuaternionReadOnly orientation, Vector3DReadOnly angularVelocity) {
        this.setTime(time);
        this.setIncludingFrame(referenceFrame, orientation, angularVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, SO3TrajectoryPointBasics trajectoryPoint) {
        this.setTime(trajectoryPoint.getTime());
        FrameSO3WaypointBasics.super.setIncludingFrame(referenceFrame, trajectoryPoint);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, double time, SO3WaypointBasics waypoint) {
        this.setTime(time);
        this.setIncludingFrame(referenceFrame, waypoint);
    }

    default public void setIncludingFrame(FrameSO3TrajectoryPointBasics other) {
        this.setTime(other.getTime());
        FrameSO3WaypointBasics.super.setIncludingFrame(other);
    }

    default public void set(FrameSO3TrajectoryPointBasics other) {
        this.setTime(other.getTime());
        FrameSO3WaypointBasics.super.set(other);
    }

    default public void getIncludingFrame(FrameSO3TrajectoryPointBasics otherToPack) {
        otherToPack.setIncludingFrame(this);
    }

    default public void get(FrameSO3TrajectoryPointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public boolean epsilonEquals(FrameSO3TrajectoryPointBasics other, double epsilon) {
        boolean timeEquals = EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon);
        return timeEquals && FrameSO3WaypointBasics.super.epsilonEquals(other, epsilon);
    }
}

