/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSE3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SE3WaypointBasics;

public interface FrameSE3TrajectoryPointBasics
extends SE3TrajectoryPointBasics,
FrameSE3WaypointBasics,
FrameEuclideanTrajectoryPointBasics,
FrameSO3TrajectoryPointBasics {
    default public void set(double time, FramePoint3DReadOnly position, FrameQuaternionReadOnly orientation, FrameVector3DReadOnly linearVelocity, FrameVector3DReadOnly angularVelocity) {
        this.setTime(time);
        this.set(position, orientation, linearVelocity, angularVelocity);
    }

    default public void set(double time, FrameSE3WaypointBasics waypoint) {
        this.setTime(time);
        this.set(waypoint);
    }

    default public void set(double time, FrameEuclideanWaypointBasics euclideanWaypoint, FrameSO3WaypointBasics so3Waypoint) {
        this.setTime(time);
        this.set(euclideanWaypoint);
        this.set(so3Waypoint);
    }

    default public void setIncludingFrame(double time, FrameEuclideanWaypointBasics euclideanWaypoint, FrameSO3WaypointBasics so3Waypoint) {
        this.setTime(time);
        euclideanWaypoint.checkReferenceFrameMatch((ReferenceFrameHolder)so3Waypoint);
        this.setReferenceFrame(euclideanWaypoint.getReferenceFrame());
        this.set(euclideanWaypoint);
        this.set(so3Waypoint);
    }

    default public void setIncludingFrame(double time, FrameSE3WaypointBasics waypoint) {
        this.setTime(time);
        this.setIncludingFrame(waypoint);
    }

    default public void setIncludingFrame(double time, FramePoint3DReadOnly position, FrameQuaternionReadOnly orientation, FrameVector3DReadOnly linearVelocity, FrameVector3DReadOnly angularVelocity) {
        this.setTime(time);
        this.setIncludingFrame(position, orientation, linearVelocity, angularVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, double time, Point3DReadOnly position, QuaternionReadOnly orientation, Vector3DReadOnly linearVelocity, Vector3DReadOnly angularVelocity) {
        this.setTime(time);
        this.setIncludingFrame(referenceFrame, position, orientation, linearVelocity, angularVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, SE3TrajectoryPointBasics trajectoryPoint) {
        this.setTime(trajectoryPoint.getTime());
        FrameSE3WaypointBasics.super.setIncludingFrame(referenceFrame, trajectoryPoint);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, double time, SE3WaypointBasics waypoint) {
        this.setTime(time);
        this.setIncludingFrame(referenceFrame, waypoint);
    }

    default public void setIncludingFrame(FrameSE3TrajectoryPointBasics other) {
        this.setTime(other.getTime());
        FrameSE3WaypointBasics.super.setIncludingFrame(other);
    }

    default public void set(FrameSE3TrajectoryPointBasics other) {
        this.setTime(other.getTime());
        FrameSE3WaypointBasics.super.set(other);
    }

    default public void getIncludingFrame(FrameSE3TrajectoryPointBasics otherToPack) {
        otherToPack.setIncludingFrame(this);
    }

    default public void get(FrameSE3TrajectoryPointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public void getIncludingFrame(FrameEuclideanTrajectoryPointBasics euclideanTrajectoryPointToPack, FrameSO3TrajectoryPointBasics so3TrajectoryPointToPack) {
        this.getIncludingFrame(euclideanTrajectoryPointToPack);
        this.getIncludingFrame(so3TrajectoryPointToPack);
    }

    default public void get(FrameEuclideanTrajectoryPointBasics euclideanTrajectoryPointToPack, FrameSO3TrajectoryPointBasics so3TrajectoryPointToPack) {
        this.get(euclideanTrajectoryPointToPack);
        this.get(so3TrajectoryPointToPack);
    }

    default public boolean epsilonEquals(FrameSE3TrajectoryPointBasics other, double epsilon) {
        boolean timeEquals = EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon);
        return timeEquals && FrameSE3WaypointBasics.super.epsilonEquals(other, epsilon);
    }

    @Override
    default public void setToNaN(ReferenceFrame referenceFrame) {
        this.setTimeToNaN();
        FrameSE3WaypointBasics.super.setToNaN(referenceFrame);
    }

    @Override
    default public void setToZero(ReferenceFrame referenceFrame) {
        this.setTimeToZero();
        FrameSE3WaypointBasics.super.setToZero(referenceFrame);
    }

    @Override
    default public void setToNaN() {
        this.setTimeToNaN();
        SE3TrajectoryPointBasics.super.setToNaN();
    }

    @Override
    default public void setToZero() {
        this.setTimeToZero();
        SE3TrajectoryPointBasics.super.setToZero();
    }

    @Override
    default public boolean containsNaN() {
        return Double.isNaN(this.getTime()) || SE3TrajectoryPointBasics.super.containsNaN();
    }
}

