/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointBasics;

public interface FrameEuclideanTrajectoryPointBasics
extends EuclideanTrajectoryPointBasics,
FrameEuclideanWaypointBasics {
    default public void set(double time, FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.setTime(time);
        this.set(position, linearVelocity);
    }

    default public void set(double time, FrameEuclideanWaypointBasics waypoint) {
        this.setTime(time);
        this.set(waypoint);
    }

    default public void setIncludingFrame(double time, FrameEuclideanWaypointBasics waypoint) {
        this.setTime(time);
        this.setIncludingFrame(waypoint);
    }

    default public void setIncludingFrame(double time, FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.setTime(time);
        this.setIncludingFrame(position, linearVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, double time, Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        this.setTime(time);
        this.setIncludingFrame(referenceFrame, position, linearVelocity);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, EuclideanTrajectoryPointBasics trajectoryPoint) {
        this.setTime(trajectoryPoint.getTime());
        FrameEuclideanWaypointBasics.super.setIncludingFrame(referenceFrame, trajectoryPoint);
    }

    default public void setIncludingFrame(ReferenceFrame referenceFrame, double time, EuclideanWaypointBasics waypoint) {
        this.setTime(time);
        this.setIncludingFrame(referenceFrame, waypoint);
    }

    default public void setIncludingFrame(FrameEuclideanTrajectoryPointBasics other) {
        this.setTime(other.getTime());
        FrameEuclideanWaypointBasics.super.setIncludingFrame(other);
    }

    default public void set(FrameEuclideanTrajectoryPointBasics other) {
        this.setTime(other.getTime());
        FrameEuclideanWaypointBasics.super.set(other);
    }

    default public void getIncludingFrame(FrameEuclideanTrajectoryPointBasics otherToPack) {
        otherToPack.setIncludingFrame(this);
    }

    default public void get(FrameEuclideanTrajectoryPointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public boolean epsilonEquals(FrameEuclideanTrajectoryPointBasics other, double epsilon) {
        boolean timeEquals = EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon);
        return timeEquals && FrameEuclideanWaypointBasics.super.epsilonEquals(other, epsilon);
    }
}

