/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointBasics;

public interface EuclideanTrajectoryPointBasics
extends TrajectoryPointBasics,
EuclideanWaypointBasics {
    default public void set(double time, Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        this.setTime(time);
        this.set(position, linearVelocity);
    }

    default public void set(EuclideanTrajectoryPointBasics other) {
        this.setTime(other.getTime());
        EuclideanWaypointBasics.super.set(other);
    }

    default public void set(double time, EuclideanWaypointBasics waypoint) {
        this.setTime(time);
        this.set(waypoint);
    }

    default public void get(EuclideanTrajectoryPointBasics otherToPack) {
        otherToPack.set(this);
    }

    default public boolean epsilonEquals(EuclideanTrajectoryPointBasics other, double epsilon) {
        boolean timeEquals = EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon);
        return timeEquals && EuclideanWaypointBasics.super.epsilonEquals(other, epsilon);
    }

    @Override
    default public void setToNaN() {
        this.setTimeToNaN();
        EuclideanWaypointBasics.super.setToNaN();
    }

    @Override
    default public void setToZero() {
        this.setTimeToZero();
        EuclideanWaypointBasics.super.setToZero();
    }

    @Override
    default public boolean containsNaN() {
        return Double.isNaN(this.getTime()) || EuclideanWaypointBasics.super.containsNaN();
    }
}

