/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.YoFrameSO3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.tools.WaypointToStringTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameSO3TrajectoryPoint
implements FrameSO3TrajectoryPointBasics {
    private final YoFrameSO3Waypoint so3Waypoint;
    private final YoDouble time;
    private final String namePrefix;
    private final String nameSuffix;

    public YoFrameSO3TrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.so3Waypoint = new YoFrameSO3Waypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
    }

    public YoFrameSO3TrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame) {
        this.so3Waypoint = new YoFrameSO3Waypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.setToZero(referenceFrame);
    }

    @Override
    public FrameQuaternionReadOnly getOrientation() {
        return this.so3Waypoint.getOrientation();
    }

    @Override
    public void setOrientation(double x, double y, double z, double s) {
        this.so3Waypoint.setOrientation(x, y, z, s);
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.so3Waypoint.getAngularVelocity();
    }

    @Override
    public void setAngularVelocity(double x, double y, double z) {
        this.so3Waypoint.setAngularVelocity(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.so3Waypoint.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.so3Waypoint.applyInverseTransform(transform);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.so3Waypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.so3Waypoint.getReferenceFrame();
    }

    @Override
    public void setTime(double time) {
        this.time.set(time);
    }

    @Override
    public double getTime() {
        return this.time.getValue();
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public String toString() {
        return "SO3 trajectory point: (time = " + WaypointToStringTools.formatTime(this.getTime()) + ", " + WaypointToStringTools.waypointToString(this.so3Waypoint) + ")";
    }
}

