/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.YoFrameSE3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.tools.WaypointToStringTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameSE3TrajectoryPoint
implements FrameSE3TrajectoryPointBasics {
    private final YoFrameSE3Waypoint se3Waypoint;
    private final YoDouble time;
    private final String namePrefix;
    private final String nameSuffix;

    public YoFrameSE3TrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.se3Waypoint = new YoFrameSE3Waypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
    }

    public YoFrameSE3TrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame) {
        this.se3Waypoint = new YoFrameSE3Waypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.setToZero(referenceFrame);
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.se3Waypoint.getPosition();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.se3Waypoint.setPosition(x, y, z);
    }

    @Override
    public FrameVector3DReadOnly getLinearVelocity() {
        return this.se3Waypoint.getLinearVelocity();
    }

    @Override
    public void setLinearVelocity(double x, double y, double z) {
        this.se3Waypoint.setLinearVelocity(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.se3Waypoint.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.se3Waypoint.applyInverseTransform(transform);
    }

    @Override
    public FrameQuaternionReadOnly getOrientation() {
        return this.se3Waypoint.getOrientation();
    }

    @Override
    public void setOrientation(double x, double y, double z, double s) {
        this.se3Waypoint.setOrientation(x, y, z, s);
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.se3Waypoint.getAngularVelocity();
    }

    @Override
    public void setAngularVelocity(double x, double y, double z) {
        this.se3Waypoint.setAngularVelocity(x, y, z);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.se3Waypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.se3Waypoint.getReferenceFrame();
    }

    @Override
    public void setTime(double time) {
        this.time.set(time);
    }

    @Override
    public double getTime() {
        return this.time.getValue();
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public String toString() {
        return "SE3 trajectory point: (time = " + WaypointToStringTools.formatTime(this.getTime()) + ", " + WaypointToStringTools.waypointToString(this.se3Waypoint) + ")";
    }
}

