/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.YoFrameEuclideanWaypoint;
import us.ihmc.robotics.math.trajectories.waypoints.tools.WaypointToStringTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameEuclideanTrajectoryPoint
implements FrameEuclideanTrajectoryPointBasics {
    private final YoFrameEuclideanWaypoint euclideanWaypoint;
    private final YoDouble time;
    private final String namePrefix;
    private final String nameSuffix;

    public YoFrameEuclideanTrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.euclideanWaypoint = new YoFrameEuclideanWaypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
    }

    public YoFrameEuclideanTrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame) {
        this.euclideanWaypoint = new YoFrameEuclideanWaypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.setToZero(referenceFrame);
    }

    public YoDouble getYoX() {
        return this.euclideanWaypoint.getYoX();
    }

    public YoDouble getYoY() {
        return this.euclideanWaypoint.getYoY();
    }

    public YoDouble getYoZ() {
        return this.euclideanWaypoint.getYoZ();
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.euclideanWaypoint.getPosition();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.euclideanWaypoint.setPosition(x, y, z);
    }

    @Override
    public FrameVector3DReadOnly getLinearVelocity() {
        return this.euclideanWaypoint.getLinearVelocity();
    }

    @Override
    public void setLinearVelocity(double x, double y, double z) {
        this.euclideanWaypoint.setLinearVelocity(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.euclideanWaypoint.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.euclideanWaypoint.applyInverseTransform(transform);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.euclideanWaypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.euclideanWaypoint.getReferenceFrame();
    }

    @Override
    public void setTime(double time) {
        this.time.set(time);
    }

    @Override
    public double getTime() {
        return this.time.getValue();
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public String toString() {
        return "Euclidean trajectory point: (time = " + WaypointToStringTools.formatTime(this.getTime()) + ", " + WaypointToStringTools.waypointToString(this.euclideanWaypoint) + ")";
    }
}

